# ifndef __autoobj_hpp
  # define __autoobj_hpp




/***************************************************************************************************************************

  FILE NAME :
    AUTOOBJ.HPP


  APPLICATION :
    GENERAL SUPERCLASS FOR AUTOMATICALLY DELETED OBJECTS
  

  DESCRIPTION :
    This header contains the declaration for the class AutoObject.  This class is used as a superclass or a mixin class that
    provides a flag that determines whether the contents of the subclass should be deleted when the object goes out of
    scope.


  CLASSES DECLARED IN THIS HEADER :
    class AutoObject


  Copyright 1997, Peter Garner
  This code may be used for any NON-MILITARY purpose.

 
***************************************************************************************************************************/
//  Locally Defined C Headers
# include <cpuport.h>     //  For Boolean definition


//  Locally Defined C++ Headers
# include <namedobj.hpp>



class AutoObject : public NamedObject
{
public    :
//  Constructors
  AutoObject ( Boolean bAutoDestroy = true ) ;
  AutoObject ( const AutoObject & rcautobj ) ;

//  Virtual Constant Methods
  virtual const char    * className     ()  const ;

//  Virtual Methods
  virtual void            destroy       ()  ;

//  Constant Methods
  Boolean                 willDestroy   ()  const ;

//  Methods
//  Mutator to determine whether contents should be deleted
  Boolean                 shouldDestroy ( Boolean bAutoDestroy = true ) ;

protected :
//  Protected Pure Virtual Methods
  virtual void            deleteMem     ()  = 0 ;      

private   :
  Boolean       bDestroy  ;

} ; /* class AutoObject : public NamedObject */





# endif  /*  # ifndef __autoobj_hpp  */
