# ifndef __autocntr_hpp
  # define __autocntr_hpp



//  This header contains declarations for some Auto Destroy Descendants of the OCL Collection Classes



//  Declare this inline, there is nothing really implementation dependent, so it is probably safe to
//  declare all of this headers code inline.



template < class E > IBoolean deleteFunction ( E & re , void * )
{
  delete  re   ;

  return  true ;

} /* template < class E > IBoolean deleteFunction ( E & re , void * ) */



//  Define an IKeySortedSet that deletes its contents pointers when its' destructor is called
//  THIS CLASS SHOULD ONLY BE INSTANTIATED WITH E AS A DELETABLE POINTER!!!
template < class E , class K > class AutoKeySet : public IKeySortedSet < E , K >
{
public    :
//  Destructor
  ~AutoKeySet ()  { allElementsDo ( deleteFunction )  ; }

//  Methods

  //  This method adds a pointer to the collection, but deletes the pointer being added if an exception
  //  is thrown DURING the add attempt
  IBoolean    add ( E const & crElem )
  {
    try
    {
      IKeySortedSet < E , K > :: add ( crElem ) ;

    } /* endtry */
    catch ( IException & riexcp )
    {
      //  Cast off the Constantness, these should only be pointers anyway!
      E & re = (E &) crElem ;

      //  Call our delete method
      deleteFunction ( re ) ;

      //  And rethrow the exception
      throw ;

    } /* endcatch ( IException & riexcp ) */

    return  true ;

  } /* template < class E , class K > IBoolean AutoKeySet :: add ( E const & crElem ) */


} ; /* template < class E , class K > class AutoKeySet : public IKeySortedSet < E , K > */




# endif  /*  # ifndef __autocntr_hpp  */
