# ifndef _workunit_hpp
  # define __workunit_hpp


/***************************************************************************************************************************

  FILE NAME :
    workunit.hpp


  DESCRIPTION :
    This header contains the declaration for the class WorkUnit.  This class uses the "resource acquisition is
    initialization" technique to manage a database transaction (Unit of Work).  The concept behind this technique of 
    "resource acquisition is initialization" is described by Bjarne Stroustrup in "The C++ Programming Language", 1997, pp.
    366 - 7.


  CLASSES DECLARED IN THIS HEADER :
    class WorkUnit : public AutoObject 
    

  Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.

***************************************************************************************************************************/
//  Locally Defined C++ Headers
# include <autoobj.hpp>



class WorkUnit : public AutoObject 
{
public    :
//  Constructors
  WorkUnit   () ;

  //  Destructor
  ~WorkUnit  () ;

//  Virtual Constant Methods
  virtual const char      * className         ()  const ;

//  Virtual Methods
  virtual void              freeResource      () ;

//  Methods
  long                      commit            () ;
  long                      rollback          () ;

} ; /* class WorkUnit : public AutoObject  */



# endif  /*  # ifndef __workunit_hpp  */

