# ifndef __tablecol_hpp
  # define __tablecol_hpp



# include <coltrans.hpp>



class TableColumn : public NamedObject
{
public    :
//  Constructors
  TableColumn () ;

  TableColumn
    (
    unsigned        uColNo      ,
    const char    * cszColName  ,
    const char    * cszColType  ,
    unsigned        uColLength  ,
    unsigned        uColScale   ,
    IBoolean        ibNullable  ,
    unsigned        uDisplayLen = 0
    ) ;

  TableColumn 
    (
    unsigned        uColNo      ,
    const char    * cszColName  ,
    SQLDataType     sqldtypeCol ,
    unsigned        uColLength  ,
    unsigned        uColScale   ,
    IBoolean        ibNullable  ,
    unsigned        uDisplayLen = 0
    ) ;

  TableColumn ( const TableColumn & crtablecolumn ) ;

//  Virtual Constant Methods
  virtual const IString   & format        ( IString & ristrg  ) const ; //  Outputs column creation to IString
  virtual const char      * className     ()                    const ;
  virtual unsigned const  & key           ()                    const ; //  For the IBM OCL collection classes

//  Constant Methods
  unsigned                  columnLength  ()                    const ;
  const char              * columnName    ()                    const ;
  unsigned                  columnNumber  ()                    const ;
  unsigned                  columnScale   ()                    const ;
  const char              * columnType    ()                    const ;
  SQLDataType               dataType      ()                    const ;
  unsigned                  displayLength ()                    const ;
  Boolean                   isNullable    ()                    const ;

//  Methods
  unsigned                  init
                              (
                              unsigned      uColNo        ,
                              const char  * cszColName    ,
                              const char  * cszColType    ,
                              unsigned      uColLength    ,
                              unsigned      uColScale     ,
                              char          cNullable     ,  // (Y or N)
                              unsigned      uDisplayLength = 0
                              ) ;

  unsigned                  init
                              (
                              unsigned      uColNo      ,
                              const char  * cszColName  ,
                              SQLDataType   sqldtypeCol ,
                              unsigned      uColLength  ,
                              unsigned      uColScale   ,
                              Boolean       bNullable   ,
                              unsigned      uDisplayLen = 0
                              ) ;

  unsigned                  init            ( const TableColumn & crtablecolumn ) ;

private   :
  unsigned        uColumnNumber   ;
  IString         istrgColumnName ;
  ColumnTypePair  columntype      ;
  unsigned        uDisplayLength  ;
  unsigned        uLength         ;
  unsigned        uScale          ;
  Boolean         bRequired       ;

} ; /* class TableColumn : public NamedObject */



unsigned const & key ( const TableColumn & rctablecolumn ) ;


typedef IKeySortedSet < TableColumn , unsigned > IKeyedSetTabColumns ;


void getTabColumns  ( const IString & rcistrgSchema , const IString & rcistrgName , IKeyedSetTabColumns & rksettabcolumns ) ;

# endif  /*  # ifndef __tablecol_hpp  */
