
# ifndef __strfcns_h
  # define __strfcns_h


/*  System Defined C Headers  */
# include <stddef.h>              /*  For the definition of size_t  */



# ifdef __cplusplus
  extern "C"
  {
# endif  /*  # ifdef __cplusplus  */

/***************************************************************************************************************************
 
  FILE NAME :
    STRFCNS.H


  APPLICATION :
    GENERAL DECLARATIONS FOR 'C' MEMORY AND STRING HANDLING FUNCTIONS
  

  DESCRIPTION :
    This header contains the declarations for some useful memory and string functions.  These extend the 'C' library string
    routines in various ways.  E.g. strLen operates much like strlen, but will handle NULL pointers.  strTermCpy acts much
    like strncpy, but will ALWAYS null terminate the destination string.


  Copyright 1997, Peter Garner
  This code may be used for any NON-MILITARY purpose.

 
***************************************************************************************************************************/


unsigned      memCount          ( const char * pccSrch , char c , size_t stLen ) ;
short         memIsBlank        ( const char * pcTest , size_t stLen ) ;
const void  * memrchr           ( const void * pcvSrch , char c , size_t stLen ) ;
char        * strCopyFill       ( char * szDest , const char * cszSrc , char c , size_t stLen ) ;
unsigned      strCount          ( const char * pccSrch , char c ) ;
short         strIsBlank        ( const char * cszTest) ;
short         strIsValid        ( const char * szTest ) ;
size_t        strLen            ( const char * csz ) ;
char        * strLTrim          ( char * szLine ) ;
char        * strReset          ( char ** ppcDest , const char * cszSrc ) ;
char        * strRTrim          ( char * szLine ) ;
char        * strStripNewLine   ( char * szLine ) ;
char        * strTermCpy        ( char * szDest , const char * cszSrc , size_t stLen ) ;
char        * strTermFill       ( char * szDest , const char * cszSrc , char c , size_t stLen ) ;
char        * strToLower        ( char * sz ) ;
char        * strToUpper        ( char * sz ) ;


# ifdef __cplusplus
  }
# endif  /*  # ifdef __cplusplus  */



# endif  /*  # ifndef __strfcns_h  */
