# ifndef __sqlerror_hpp
  # define __sqlerror_hpp


/***************************************************************************************************************************
 
    FILE NAME :
      SQLERROR.HPP
 
 
    APPLICATION :
      DECLARATION OF A THROWABLE ERROR CLASS REPRESENTING A GENERIC SQL ERROR.
 
 
    $Archive: $
 
    $Author:   PGARNER  $
 
    $Date: $
 
    $Revision: $
 
    $Workfile:  $
 
 
 
    $Log: $
   
 
    DESCRIPTION :
      This header contains the declarations for the class SQLException.  This class provides exception handling support for
      any generic SQL database.  In general, the purpose of this class is to facilitate portability AND keep a layer of
      abstraction at a database independant level.  I.e. the general SQL code will catch SQLException object, while the
      actual object thrown would be a DB2Error, and ORACLEError or someother child class of SQLException.  To put it yet
      another way, this class should the parent of all our SQLException objects.  I.e. we should  derive further exception
      classes that are specialized for a particular database (such as DB2Error) from this class as needed.
      
 
    CLASSES DEFINED IN THIS HEADER :
      class SQLException : public  IInvalidRequest
 
 
***************************************************************************************************************************/
//  IBM OCL Defined C++ Headers
# include <iexcbase.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>



class SQLException : public IInvalidRequest , public NamedObject
{
public    :
//  Constructors
  SQLException  ( const SQLException  & rcsqlerror                      ) ;
  SQLException  ( const char          * cszMsg , unsigned long ulErrID  ) ;

//  Virtual Constant Methods
  virtual const char  * className     ()  const ;
  virtual const char  * name          ()  const ;

} ; /* class SQLException : public IInvalidRequest , public NamedObject */




# endif  /*  # ifndef __sqlerror_hpp  */
