# ifndef __sqlclass_hpp
  # define __sqlclass_hpp



//  This is an IDENTICAL definition of MAX_SQL_NAME_LEN as defined in "SQLDEFS.HPP".  For some reason the VC++ 3.0
//  Template Compiler keeps complaining that this is undefined in this header.  I am not sure what the problem is,
//  and we really do not have time at this point (23.July.96) to research it, either.  The compiler WILL complain if
//  this is redefined to something different than that in "SQLDEFS.HPP".  So we should be alright.  BUT REMEMBER THIS
//  IS A WORKAROUND AND SHOULD BE FIXED WHEN THERE IS TIME!  PLG
# define MAX_SQL_NAME_LEN   31


//  Include file for IBoolean and other definitions
# include <sqlerror.hpp>


class SQLCursor : public NamedObject
{
public    :
//  Pure Virtual Constant Methods
  virtual const char          * className       ()                    const = 0 ;
  virtual Boolean               fail            ()                    const = 0 ;
  virtual unsigned long         warning         ()                    const = 0 ;

//  Pure Virtual Methods
  virtual const char          * copyRow         ( char * szData = 0 )       = 0 ;
  virtual const SQLException  & loadSQLError    ()                          = 0 ;

//  Virtual Methods
  virtual long                  fetch           ( char * szData = 0 )           ;

protected :
//  Protected Pure Virtual Methods
  virtual long                  close           ()                          = 0 ;
  virtual SQLException        & getSQLError     ()                          = 0 ;
  virtual long                  fetchDBData     ()                          = 0 ;

//  Protected Methods
  long                          open            ()                              ;

} ; /* class SQLCursor : public NamedObject */



# endif  /*  # ifndef __sqlclass_hpp  */
