# ifndef __sortstrn_hpp
  # define __sortstrn_hpp



/***************************************************************************************************************************
 
  FILE NAME :
    SORTSTRN.HPP


  APPLICATION :
    GENERAL CLASS DECLARATION FOR A SORTED ISTRING CLASS
  

  DESCRIPTION :
    This header contains the declarations for the class SortedIStrings.  This is a descendant of the IBM OCL class 
    ISortedSet instantiated for IStrings.


  CLASSES DECLARED IN THIS HEADER :
    class SortedIStrings


  Copyright 1997, Peter Garner
  This code may be used for any NON-MILITARY purpose.

 
***************************************************************************************************************************/

//  IBM OCL Defined C++ Headers
# include <isrtset.h>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>



//  Typedef this parameterized (template) class so that we can use it easily
typedef ISortedSet <IString> SortedIStringSet ;



class SortedIStrings : public SortedIStringSet , public NamedObject
{
public :
  SortedIStrings () ;
  SortedIStrings ( const char           * cszInit       ) ;
  SortedIStrings ( const SortedIStrings & rcsortistrgs  ) ;

  virtual const char  * className     () const ;

} ; /* class SortedIStrings : public SortedIStringSet , public NamedObject */



# endif  /*  # ifndef __sortstrn_hpp  */
