# ifndef __rangein_hpp
  # define __rangein_hpp


/***************************************************************************************************************************
 
    FILE NAME :
      RangeIn.hpp
 
 
    DESCRIPTION :
      This Header contains the Declarations for the Class RangeIn.  This Class extends the OCL IRange Class by adding
      the Method  'Boolean RangeIn :: setWithin ( long & rlVal )'.  This method makes sure that 'rlVal' is within the
      Range.


    CLASSES DECLARED IN THIS HEADER :
      class RangeIn : public IRange



    Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.
 
***************************************************************************************************************************/
//  IBM OCL Defined C++ Headers
# include <ipoint.hpp>



class RangeIn : public IRange
{
public    :
//  Constructors
  RangeIn   ()                                : IRange ()                     {}
  RangeIn   ( Coord coordLo , Coord coordHi ) : IRange ( coordLo , coordHi )  {}
  RangeIn   ( const IPair & rcipair )         : IRange ( rcipair )            {}

//  Virtual Constant Methods
  Boolean                 setWithin         ( long & rlVal ) const
  {
    //  If the value is BELOW the minimum Value, set it to the minimum Value and return false
    if ( rlVal < lowerBound () )
    {
      rlVal = lowerBound () ;

      return  false ;

    } /* endif */

    //  If the value is ABOVE the maximum Value, set it to the maximum Value and return false
    if ( rlVal > upperBound () )
    {
      rlVal = upperBound () ;

      return  false ;

    } /* endif */

    return  true ;

  } /* Boolean RangeIn :: setWithin ( long & rlVal ) const */

} ; /* class RangeIn : public IRange */




# endif  /*  # ifndef __rangein_hpp  */





