# ifndef __ourstrng_hpp
  # define __ourstrng_hpp



/***************************************************************************************************************************
 
    FILE NAME   :
      OURSTRNG.HPP
 
 
    APPLICATION :
      GENERAL - DECLARATION OF A GENERIC STRING CLASS THAT CAN BE USED WITH COMPILERS THAT DO NOT SUPPORT THE STL OR ANSI
      STRING CLASS.


    DESCRIPTION :
      This header contains the declarations for the class OurString.  This class is intended to subsitute for the STL or
      ANSI String classes for compilers that do not support those classes.
      
 
    CLASSES DEFINED IN THIS HEADER :
      class OurString : public CharrArray

 
***************************************************************************************************************************/
//  Locally Defined C++ Headers
# include <templary.hpp>



class OurString : public CharArray
{
public    :
//  Constructors
  OurString   ( const char * cszSourceString = 0 ) ;
  OurString   ( size_t stLen , const char * ccaSource = 0 ) ;
  OurString   ( const OurString & rcourstring ) ;

//  Virtual Constant Methods
  const char            * className     ()  const ;

//  Constant Methods
  size_t                  length        ()  const ;

//  Virtual Methods
  virtual void            clear         ()                              ; //  Set entire internal buffer to 0

//  Operators
  OurString             & operator  =   ( const char      * cszSource ) ;
  OurString             & operator  =   ( const OurString & rcourstrg ) ;
  OurString             & operator  +=  ( const char      * cszSource ) ;
  OurString             & operator  +=  ( const OurString & rcourstrg ) ;
  Boolean                 operator  ==  ( const char      * cszSource ) ;
  Boolean                 operator  ==  ( const OurString & rcourstrg ) ;
  Boolean                 operator  !=  ( const char      * cszSource ) ;
  Boolean                 operator  !=  ( const OurString & rcourstrg ) ;
  Boolean                 operator  <=  ( const char      * cszSource ) ;
  Boolean                 operator  <=  ( const OurString & rcourstrg ) ;
  Boolean                 operator  >=  ( const char      * cszSource ) ;
  Boolean                 operator  >=  ( const OurString & rcourstrg ) ;
  Boolean                 operator  <   ( const char      * cszSource ) ;
  Boolean                 operator  <   ( const OurString & rcourstrg ) ;
  Boolean                 operator  >   ( const char      * cszSource ) ;
  Boolean                 operator  >   ( const OurString & rcourstrg ) ;

} ; /* class OurString : public CharArray */



const OurString operator + ( const char       * csz         , const OurString & rcourstrg   ) ;
const OurString operator + ( const OurString  & rcourstrg   , const char      * csz         ) ;
const OurString operator + ( const OurString  & rcourstrg1  , const OurString & rcourstrg2  ) ;


# endif  /*  # ifndef __ourstrng_hpp  */
