# ifndef  __namedobj_hpp
  # define  __namedobj_hpp


/***************************************************************************************************************************

  FILE NAME :
    NAMEDOBJ.HPP


  APPLICATION :
    GENERAL SUPERCLASS FOR ALL OF C++ CLASSES.
  

  DESCRIPTION :
    This header contains the declaration for the class NamedObject.  I use this class as a superclass from which ALL of
    other classes descend.  Conceptually, NamedObject is something of a C++ replacement for the SmallTalk class object.
    The practical purpose of this class is to allow each class to return its' type name via the method :

        virtual const char * NamedObject :: className    () const

    Something similiar was implemented by the (now obsolete) NIMH Container Class Library, and one can use this information
    in a variety of ways, including limited Run Time Type Identification (RTTI).

    PERHAPS MOST IMPORTANTLY THIS CLASS DEFINES A DO NOTHING VIRTUAL DESTRUCTOR.  THIS ASSURES THAT THE DESTRUCTORS OF ALL
    DESCENDANT CLASSES WILL BE VIRTUAL AS WELL!


  CLASSES DECLARED IN THIS HEADER :
    class NamedObject


  Copyright 1997, Peter Garner
  This code may be used for any NON-MILITARY purpose.

 
***************************************************************************************************************************/

//  System defined C Headers
# include <stddef.h>    //  For the definition of size_t



// This is an abstract base class for ALL of our defined classes.  Note
// that one of its' reasons for being is that it has a virtual destructor,
// thus forcing all of its' descendants destructors to be virtual!

class NamedObject
{
public    :
//  Destructor
  virtual ~NamedObject                () ;

//  Virtual Constant Methods
  virtual const char  * className     ()  const ;

//  Constant Methods
  int                   isMyType      ( const NamedObject  & rcnamedobject )  const ;
  size_t                nameLength    ()  const ;

} ;     /*  class NamedObject */



# endif  /*  # ifndef  __namedobj_hpp  */
