# ifndef __fstrmchk_hpp
  # define __fstrmchk_hpp


/***************************************************************************************************************************
 
    FILE NAME :
      FSTRMCHK.HPP
 
 
    APPLICATION :
      GENERAL - DECLARATION OF AN FSTREAM DESCENDANT THAT WILL THROW AN EXCEPTION UPON FAILURE OF FILE PRIMITIVES


    DESCRIPTION :
      This header contains the declarations for the class FStreamCheck.  This class is intended to subsitute
      for its' base class "fstream".  The FStreamCheck class adds exception handling.  I.e. the primitives :
      open, read, write, and seek will all throw an exception of type "FStreamError" an error occurs.
      
 
    CLASSES DEFINED IN THIS HEADER :
      class FStreamCheck : virtual public fstream , public NamedObject 
      class FStreamError : public IAccessError    , public NamedObject 
 
***************************************************************************************************************************/
//  System Defined C++ Headers
# include <fstream.h>


//  Locally Defined C++ Headers
# include <generror.hpp>
# include <ourstrng.hpp>



# define CHECK_STATE()\
            { if ( ! good () ) { int nState = rdstate () ; clear () ; THROW_FSTREAM_ERROR ( fileName () , nState ) ; } }

# define CHECK_FAIL()\
            { if ( fail () )   { int nState = fail    () ; clear () ; THROW_FSTREAM_ERROR ( fileName () , nState ) ; } }


# define THROW_FSTREAM_ERROR( cszMsg , nState ) { FStreamError fstrmerror ( cszMsg , nState ) ; THROW ( fstrmerror ) ; }






class FStreamCheck : public NamedObject , virtual public fstream
{
public    :
  //  Constructors
  FStreamCheck () ;
  FStreamCheck ( const char * cszName , int nIO_Mode , int nProt = filebuf :: openprot ) ;
  FStreamCheck ( int nFileDesc ) ;
  FStreamCheck ( int nFileDesc , char * pcBuffer , int nLength ) ;

  //  Virtual Constant Methods
  virtual const char  * className   () const  ;

  //  Virtual Methods
  virtual streampos fSize           () ;
  virtual streampos seekoff         ( streamoff , ios :: seek_dir , int =ios :: in | ios :: out ) ;
  virtual streampos seekpos         ( streampos , int = ios ::in | ios :: out ) ;

//  Constant Methods
  const char          * fileName    ()  const ;

  //  Methods
  void                  checkState  () ;

  void                  open      
                          (
                          const char  * cszFileName                       ,
                          int           nIO_Mode    = DEF_IO_MODE         ,
                          int           nProt       = filebuf :: openprot
                          ) ;

  istream             & read        ( char                * pcData      , int nLength ) ;
  istream             & read        ( signed char         * pscData     , int nLength ) ;
  istream             & read        ( unsigned char       * pucData     , int nLength ) ;
  ostream             & write       ( const char          * pccData     , int nLength ) ;
  ostream             & write       ( const signed char   * pcscData    , int nLength ) ;
  ostream             & write       ( const unsigned char * pcucData    , int nLength ) ;

  //  ENUMS
  enum OpenMode { DEF_IO_MODE = ios :: in | ios :: out , DEF_RD_MODE = ios :: in | ios :: nocreate } ;

protected :
  const char            * setFileName   ( const char * cszFileName )  ;

private   :
  OurString             ourstrgFileName  ;

} ; /* class FStreamCheck : public NamedObject , virtual public fstream */



class FStreamError : public IAccessError , public NamedObject
{
public    :
//  Constructors
  FStreamError ( const char         * cszErrMsg       , long lErrorID ) ;
  FStreamError ( const FStreamError & rcfstreamerror                  ) ;

//  Virtual Constant Methods
  virtual const char  * className           ()  const ;
  virtual const char  * name                ()  const ;

} ; /* class FStreamError : public IAccessError , public NamedObject */



# endif  /*  # ifndef __fstrmchk_hpp  */
