# ifndef __dbinfo_hpp
  # define __dbinfo_hpp




// IBM DB2 Defined C Headers
# include <sqlenv.h>


// IBM OCL Defined C++ Headers
# include <iksset.h>
# include <istring.hpp>


// Locally Defined C++ Headers
# include <namedobj.hpp>
# include <sortstrn.hpp>




//  Maximum length of a string to hold ALL dbinfo information including a space between the fields
const size_t  cstGblMaxDBInfo = SQL_NNAME_SZ  + 1 + 
                                SQL_DBNAME_SZ + 1 + 
                                SQL_ALIAS_SZ  + 1 + 
                                SQL_DBTYP_SZ  + 1 + 
                                SQL_DRIVE_SZ  + 1 + 
                                SQL_INAME_SZ  + 1 + 
                                SQL_CMT_SZ    + 1 ;   




class DBInfo : public NamedObject
{
public    :
//  Constructors
  DBInfo ( sqledinfo & rsqledinfo ) ;

  DBInfo ( const DBInfo & crdbinfo ) ;

//  Virtual Constant Methods
  virtual const char    * className         () const ;
  virtual const char    * infoAsString      ( IString & ristrg ) const ;

//  Constant Methods
  const char            * dbAlias           () const ;
  const char            * dbComment         () const ;
  const char            * dbDir             () const ;
  const char            * dbDrive           () const ;
  const char            * dbName            () const ;
  const char            * dbNode            () const ;
  const char            * dbType            () const ;
  const IString         & getKey            () const ;

//  Operators
  const DBInfo  & operator =    ( const DBInfo  & crdbinfo      ) ;

protected :
//  Methods
  const char            * setDBAlias        ( const char    * cszAlias      ) ;
  const char            * setDBComment      ( const char    * cszComment    ) ;
  const char            * setDBDir          ( const char    * cszDirectory  ) ;
  const char            * setDBDrive        ( const char    * cszDrive      ) ;
  const char            * setDBName         ( const char    * cszName       ) ;
  const char            * setDBNode         ( const char    * cszNode       ) ;
  const char            * setDBType         ( const char    * cszType       ) ;
  const DBInfo          & init              ( const DBInfo  & crdbinfo      ) ;
                                        
private   :
  char            szDBAlias   [SQL_ALIAS_SZ   + 1]  ;
  char            szDBComment [SQL_CMT_SZ     + 1]  ;
  char            szDBDir     [SQL_INAME_SZ   + 1]  ;
  char            szDBDrive   [SQL_DRIVE_SZ   + 1]  ;
  char            szDBName    [SQL_DBNAME_SZ  + 1]  ;
  char            szDBNode    [SQL_NNAME_SZ   + 1]  ;
  char            szDBType    [SQL_DBTYP_SZ   + 1]  ;

  IString         istrgKey  ;

} ; /* class DBInfo : public NamedObject */



IString const & key ( const DBInfo & rcdbinfo ) ;



typedef IKeySortedSet < DBInfo , IString > KeySortedDBInfo ;


long getAllDatabases      ( KeySortedDBInfo & keysorteddbinfo ) ;
long getAllDatabaseInfo   ( SortedIStrings  & srtstrngset     ) ;
long getAllDatabaseNames  ( SortedIStrings  & srtstrngset     ) ;





# endif  /*  # ifndef __dbinfo_hpp  */

