# ifndef __dbcon_hpp
  # define __dbcon_hpp




class DBConnection : public DatabaseObject , public ThreadSafeObject
{
public    :
//  Constructors
  DBConnection ( const char * cszServer = 0 , const char * cszUser = 0 , const char * cszPassWord = 0 ) ;
  DBConnection ( DBConnection & rcdbcon ) ;

//  Pure Virtual Methods
  virtual long            connect           ()  = 0   ;
  virtual long            disconnect        ()  = 0   ;
  virtual long            commit            ()  = 0   ;
  virtual long            rollback          ()  = 0   ;

// Methods
  Boolean                 isConnected       ()        ;
  const char            * server            ()        ;
  const char            * user              ()        ;
  const char            * password          ()        ;

  const char            * setServer         ( const char * cszServerNew    ) ;
  const char            * setUser           ( const char * cszUserNew      ) ;
  const char            * setPassword       ( const char * cszPassWordNew  ) ;

protected :
//  Methods
  Boolean                 setConnected      ( Boolean  bFlag = true ) ;

private   :
  Boolean   bIsConnected  ;
  IString   istrgServer   ;
  IString   istrgUser     ;
  IString   istrgPassWd   ;
  
} ; /* class DBConnection : public DatabaseObject , public ThreadSafeObject */




# endif  /*  # ifndef __dbcon_hpp  */
