# ifndef __db2trans_hpp
  # define __db2trans_hpp




//  This class is a utility that converts datatype and null from DB2 to standard format
class DB2ColumnTranslator : public ColumnInfoTranslator
{
public    :
  ColumnInfoTranslator  () ;

  virtual const char      * className         ()                            const = 0 ;  
  virtual SQLDataType       convertFromChar   ( const char  * cszDataType ) const = 0 ;  
  virtual char              convertFromBool   ( IBoolean      ibNullable  ) const = 0 ;  
  virtual IBoolean          convertToBool     ( char          cNullableYN ) const = 0 ;  
  virtual const char      * convertToChar     ( SQLDataType   sqldatatype ) const = 0 ;  
  virtual char              convertToStandard ( long          lNativeType ) const = 0 ;  

protected :
  const SQLDataTypeTranslator & getTypeTranslator () const ;
  SQLDataTypeTranslator       & getTypeTranslator () ;

private   :
  SQLDataTypeTranslator     sqldatatranslator ;

} ; /* class DB2ColumnTranslator : public ColumnInfoTranslator */







# endif  /*  # ifndef __db2trans_hpp  */
