# ifndef __db2error_hpp
  # define __db2error_hpp




/*************************************************************************************************************
 
    FILE NAME :
      DB2ERR.HPP
 
 
    APPLICATION :
      DECLARATION OF A THROWABLE ERROR CLASS REPRESENTING AN IBM DB2 ERROR.
 
 
    $Archive: $
 
    $Author:   PGARNER  $
 
    $Date: $
 
    $Revision: $
 
    $Workfile: $
 
 
 
    $Log: $
   
 
    DESCRIPTION :
      This header contains the declarations for the class DB2Error.  This class provides exception handling
      support for IBM DB2 Errors.
      
 
    CLASSES DEFINED IN THIS HEADER :
      class DB2Error     : public  SQLException
 
 
*************************************************************************************************************/
//  Locally Defined C++ Headers
# include <sqlerror.hpp>



// This is a macro for throwing an DB2Error
# define  THROW_DB2_ERR(psqlca) DB2Error db2error ( psqlca ) ; ITHROW ( db2error )


# define CHECK_SQL_CODE() { if ( sqlca.sqlcode < 0 ) { THROW_DB2_ERR ( & sqlca ) ; } }

# define RETURN_SQL_CODE() CHECK_SQL_CODE () return sqlca.sqlcode



class DB2Error : public SQLException
{
public    :
//  Constructors
  DB2Error      ( const DB2Error  & crdb2error                        ) ;
  DB2Error      ( const char      * cszMsg  , unsigned long ulErrID   ) ;
  DB2Error      ( struct sqlca    * psqlca                            ) ;

//  Virtual Constant Methods
  virtual const char  * className     ()  const ;

//  Methods
  long                  init          ( struct sqlca  * psqlca ) ;

} ; /* class DB2Error : public SQLException */





# endif  /*  # ifndef __db2error_hpp  */
