# ifndef __db2cursor_hpp
  # define __db2cursor_hpp



class DB2Cursor : public SQLCursor
{
public    :
//  Constructors
  DB2Cursor   ()  ;

//  Pure Virtual Constant Methods
  virtual const char          * className       ()  const = 0             ;

//  Pure Virtual Methods
  virtual const char          * copyRow         ( char * szData = 0 ) = 0 ;

//  Virtual Methods
  virtual const SQLException  & loadSQLError    ()                        ;

//  Virtual Constant Methods
  virtual IBoolean              fail            ()  const                 ;
  virtual unsigned long         warning         ()  const                 ;

protected :
//  Protected Pure Virtual Methods
  virtual long                  close           ()  = 0                   ;
  virtual long                  fetchDBData     ()  = 0                   ;

//  Protected Virtual Methods
  virtual DB2Error            & getDB2Error     ()                        ;
  virtual SQLException        & getSQLError     ()                        ;

//  Protected Data
  struct sqlca          sqlca                                             ; //  Leave this protected so that
                                                                            //  descendants have access.
private   :
  DB2Error                  db2errorInternal  ;

} ; /* class DB2Cursor : public SQLCursor */



# endif  /*  # ifndef __db2cursor_hpp  */
