# ifndef __coltrans_hpp
  # define __coltrans_hpp


//  System Defined C Headers
# include <errno.h>


//  IBM OCL Defined C++ Headers
# include <iksbag.h>


//  Locally Defined C++ Headers
# include <keystrng.hpp>

//  Typedefine for datatype string pairs, e.g. {enCHAR      , "CHARACTER"}
typedef KeyedString   ColumnTypePair  ;


//  Typedefine for A SORTED COLLECTION of datatype string pairs, e.g. {enCHAR      , "CHARACTER"}
typedef IKeySortedBag < ColumnTypePair , short > SQLDataTypeTranslator ;


typedef enum
{
  enUNKNOWN = 0 ,
  enCHAR        , 
  enVARCHAR     ,
  enSMALLINT    ,
  enINT         ,
  enFIXED       ,
  enFLOAT       , 
  enDATE        ,
  enTIME        , 
  enDATETIME    ,
  enBLOB        ,
  enCBLOB

} SQLDataType  ;


//  This class is a utility that converts datatype and null from DB2 to standard format
class ColumnInfoTranslator : public NamedObject
{
public    :
  ColumnInfoTranslator  () ;

  virtual const char      * className       ()                            const ;  
  virtual SQLDataType       fromString      ( const char  * cszDataType ) const ;  
  virtual const char      * toString        ( SQLDataType   sqldatatype ) const ;  
  virtual char              fromBool        ( Boolean       bNullable   ) const ;  
  virtual IBoolean          toBool          ( char          cNullableYN ) const ;  

protected :
  const SQLDataTypeTranslator & getTypeTranslator () const ;
  SQLDataTypeTranslator       & getTypeTranslator () ;

private   :
  SQLDataTypeTranslator     sqldatatranslator ;

} ; /* class ColumnInfoTranslator : public NamedObject */





# endif  /*  # ifndef __coltrans_hpp  */
