# ifndef __currtime_hpp
  # define __currtime_hpp

/***************************************************************************************************************************
 
    FILE NAME :
      CURRTIME.HPP
 
 
    DESCRIPTION :
      This module contains the methods used to implement the class CurrentTime.  This class simply returns the current time
      as a long or a string via calls to the C Library functions ::time and ::ctime.  In essence this class is simply a
      wrapper for those C Library functions.
 
 
    Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.
 
***************************************************************************************************************************/

const size_t  stTIME_LEN  = 31 ;

class CurrentTime : public NamedObject
{
public    :
//  Constructors
  CurrentTime () ;

//  Virtual Constant Methods
  virtual const char  * className     () const ;

//  Methods
  long                  charTime      ( char * szTime = 0 ) ;

protected :
  long  init  () ;

private   :
  char    szCurrentTime [stTIME_LEN + 1]  ;
  time_t  ttCurrent                       ;

} ; /* class CurrentTime : public NamedObject */



//  Non Member Functions for printing these classes on an ostream
ostream & operator << ( ostream & rostream , CurrentTime & rcurrtime ) ;




# endif  /*  # ifndef __currtime_hpp  */
