/*

   PETEPORT.H

   Definitions for portability as outlined in "Reliable Data Structures
   in C" by Thomas Plum, 1985 Plum Hall.

   THESE ARE ENVIRONMENT DEPENDENENT - ADJUST TO LOCAL SYSTEM

*/


# ifndef __PETEPORT_H_
# define __PETEPORT_H_


/*  Adjust these names to local machine/compiler environment.                   */

typedef unsigned char   uchar     ;   /* another mnemonic for an unsigned byte  */
typedef unsigned char   utiny     ;   /* to get an unsigned byte                */
typedef unsigned short  ushort    ;
typedef unsigned int    uint      ;

#ifndef __AIX__
  typedef unsigned long   ulong     ;
#endif

typedef unsigned        index_t   ;   /* Ad-lib locally.  (?)                   */
typedef void          * data_ptr  ;   /* Use ANSI generic pointer if avail.     */


/*  These names require no changes and will work anywhere.                          */

typedef char            tbits     ;     /*  One byte, for bitwise uses.             */
typedef char            tbool     ;     /*  one byte: {0:1}                         */
typedef ushort          bits      ;     /*  16 bits (or more), for bitwise uses     */
typedef short           metachar  ;     /*  return from getchar: {EOF, 0:UCHAR_MAX} */

# ifndef _BooleanConst                  /*  This define is for compatibility with   */
  # define _BooleanConst                /*  other compilers and headers that may    */
                                        /*  also define true and false.  rename     */
                                        /*  the define for your compiler            */

typedef int             Boolean   ;     /*  More general Boolean typedef            */

enum                    bool { false = 0 , FALSE = 0 , true = 1 , TRUE = 1 } ; /* for function returns {0:1} */

# endif  /* # ifndef _BooleanConst */


/*   These should be adjusted so the names correspond to the number of bits.        */
# ifdef __PC_DOS__
  typedef   signed char     SBYTE8   ;
  typedef   uchar           UBYTE8   ;
  typedef   short           SINT16   ;
  typedef   ushort          UINT16   ;
  typedef   long            SINT32   ;
  typedef   ulong           UINT32   ;

  # define  MAXINT          0x7FFF
  # define  MAXLONG         0x7FFFFFFF

  # define  MAXUINT         0xFFFF
  # define  MAXULONG        0xFFFFFFFF

# else
  typedef   signed char     SBYTE8   ;
  typedef   uchar           UBYTE8   ;
  typedef   short           SINT16   ;
  typedef   ushort          UINT16   ;
  typedef   int             SINT32   ;
  typedef   uint            UINT32   ;

  # define  MAXINT          0x7FFFFFFF
  # define  MAXLONG         0x7FFFFFFF

  # define  MAXUINT         0xFFFFFFFF
  # define  MAXULONG        0xFFFFFFFF

# endif

/*  Modulo function giving non-negative result.                       */
/*  If i % j is never negative on local compiler replace with:        */
/*  # define IMOD(i, j) ((i) % (j))                                   */

# define IMOD(i, j) {(((i) % (j)) < 0 ? ((i) % (j)) + (j) :  ((i) % (j)))}



/*  This macro will convert unsigned int to signed int portably, here */
/*  it is defined for two's complement.  It is more complicated for   */
/*  for one's complement.                                             */

# define U_TO_I(ui) {(int) (ui)}



/*  defined constants  */

# define TRUE       1
# define FALSE		  0
# define FAIL       -1   /* failure exit */
# define SUCCEED    0    /* normal exit  */
# define STDIN      0    /* standard input */
# define STDOUT     1    /* standard output */
# define STDERR     2    /* standard error output */
# define SEEK_SET   0    /* seek relative to start of file */
# define SEEK_CUR   1    /* seek relative to current position in file */
# define SEEK_END   2    /* seek relative to end of file */


# ifdef __AIX__
  # define DIR_SEPARATOR  '/'
# else
  # define DIR_SEPARATOR  '\\'
# endif



/*  Many C, C++ and SQL Compilers have a maximum number of 31 or 32 significant characters */
# define  MAX_C_IDENTIFIER    31



# endif		/* # ifndef __PETEPORT_H_	*/

