/***************************************************************************************************************************
 
    FILE NAME :
      BUFFILE.HPP
 
 
    DESCRIPTION :
      This header contains the declarations for the class BuffedFile.  This class reads an entire file into memory and
      then closes the file.  Its' purpose is to provide the ability to treat a file as a memory buffer.  Thus this class
      is a little bit like a UNIX memory mapped file.  However, unlike a UNIX memory mapped file, once the physical disk
      file has been read into memory, it is closed, unlocked and is available to other processes.
 
 
    Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.
 
***************************************************************************************************************************/

# ifndef __buffile_hpp
# define __buffile_hpp


# include <fstrmchk.hpp>


# ifdef __AIX__  //  Binary flag is not supported by AIX!
  const int cnDEF_IN_MODE   = ios :: in  | ios :: nocreate  ;
  const int cnDEF_OUT_MODE  = ios :: out                    ;
# endif


# ifdef __OS2__
  const int cnDEF_IN_MODE   = ios :: in  | ios :: binary | ios :: nocreate  ;
  const int cnDEF_OUT_MODE  = ios :: out | ios :: binary                    ;
# endif


# ifdef __PC_DOS__
  const int cnDEF_IN_MODE   = ios :: in  | ios :: binary | ios :: nocreate  ;
  const int cnDEF_OUT_MODE  = ios :: out | ios :: binary                    ;
# endif


class BuffedFile  : public FStreamCheck
{
public    :
//  Constructors
  BuffedFile ( const char * cszFileName = 0 , int nIO_Mode = cnDEF_IN_MODE ) ;
  BuffedFile ( const char * ccaBuffer   , size_t stBuffLength ) ;

//  Virtual Constant Methods
  virtual const char  * className     ()  const ;
  virtual const char  * buffer        ()  const ;

//  Virtual Methods
  virtual void          flush         ( const char * cszFileName , int nIO_Mode = cnDEF_OUT_MODE ) ;
  virtual char        * buffer        () ;
  virtual char        * read          ( const char * cszFileName , int nIO_Mode = cnDEF_IN_MODE  ) ;

//  Constant Methods
  size_t                length        ()  const ;

protected :
//  Protected Constant Methods
  const CharArray     & charArray     ()  const ;

//  Protected Methods
  CharArray           & charArray     () ;
  size_t                setLength     ( size_t stBuffLength )  ;

private   :
  CharArray   chararray ;

} ; /* class BuffedFile  : public FStreamCheck */





# endif  /*  # ifndef __buffile_hpp  */
