//  System Defined C Headers
# include <errno.h>
# include <stdio.h>
# include <string.h>
# include <stdlib.h>
# include <math.h>
# include <time.h>


//  Locally Defined C Headers
# include <filename.h>

//  DB2 Defined C Headers
# include <sqlutil.h>


//  System Defined C++ Headers
# include <iostream.h>


//  IBM OCL Defined C++ Headers
# include <iexcbase.hpp>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <sqldefs.hpp>
# include <sqlerror.hpp>
# include <db2error.hpp>


void initLoadInputStructure   ( sqluload_in   & rsqluloadInputInfo  ) ;
void initLoadOutputStructure  ( sqluload_out  & rsqluloadOutputInfo ) ;



long sqlLoadDelim ( char * szDataFile , char * szLocalFile , char * szRemotFile , char * szInsertStatement )
{
  //  Uninitialized Data
  sqlu_media_list   sqlmediaDataFileList  ;
  sqluload_in       sqluloadInputInfo     ;
  sqluload_out      sqluloadOutputInfo    ;

  //  Initialized Data
  size_t            stStatementLen      = strlen ( szInsertStatement )  ;
  void            * pvReserved          = 0                             ;

  //  Allocate 2 IStrings to act as automatic buffers
  IString           istrgSQLChar     ( 0 , sizeof ( struct sqlchar ) + stStatementLen ) ;
  IString           istrgFileName    ( 0 , sizeof ( sqlu_location_entry  )  )  ;

  //  Make sure the data input (delimited) file name ends in ".DEL"
  replaceExtension ( szDataFile , ".DEL" ) ;

  //  Initialize the Input structure
  initLoadInputStructure ( sqluloadInputInfo ) ;

  //  Initialize the Output structure
  initLoadOutputStructure ( sqluloadOutputInfo ) ;

  sqlchar             * sqlcharAction   = (sqlchar *)             ( (char *) istrgSQLChar  ) ;
  sqlu_location_entry * sqlulocFileName = (sqlu_location_entry *) ( (char *) istrgFileName ) ;

  sqlcharAction -> length = stStatementLen ;
  memcpy ( sqlcharAction -> data , szInsertStatement , stStatementLen ) ;

  strcpy ( sqlulocFileName -> location_entry , szDataFile ) ;

  //  Initialize the DataFile List
  memset ( & sqlmediaDataFileList , 0 , sizeof ( sqlmediaDataFileList ) ) ;
  sqlmediaDataFileList.media_type       = SQLU_SERVER_LOCATION            ;
  sqlmediaDataFileList.sessions         = 1                               ;
  sqlmediaDataFileList.target.location  = sqlulocFileName                 ;

  //  Inform user as to Remote File Name so that may execute a "LOAD QUERY" to determine the load status.
  cout  << "About to attempt to load file : \"" << szDataFile << "\", using load statement :\n"
        << szInsertStatement << "\nLocal  Message File Name is : " << szLocalFile
        << "\nRemote Message File Name is : " << szRemotFile << '\n' << endl ;

  //  Please see the "DB2 API REFERENCE" for further information on the sqluload API and its' arguments
  sqluload 
    (
    & sqlmediaDataFileList  ,   //  List of Input Files, Devices, Pipes, etc.
      0                     ,   //  LOB Path List, we aren't loading any BLOBS, so we don't need this!
      0                     ,   //  sqldcol (Data Descriptor), Don't need, we are using the DEFAULT method.
      sqlcharAction         ,   //  The load insert statement as an (sqlchar *)
      SQL_DEL               ,   //  FileType, our file is ASCII delimited text, so FileType is SQL_DEL
      0                     ,   //  FileTypeMod, This is NULL since we don't need any File Type Modifier.
      szLocalFile           ,   //  ASCIIZ Name of the file in which to place any load messages.
      szRemotFile           ,   //  ASCIIZ Name of the REMOTE file, please see the "DB2 API REFERENCE" for
                                //  information on REMOTE FILES, they are too complex to describe.
      SQLU_INITIAL          ,   //  Caller Action, SQLU_INITIAL means we are starting a load from scratch.
    & sqluloadInputInfo     ,   //  Optional INPUT structure, provides restart count, commit frequency, etc.
    & sqluloadOutputInfo    ,   //  Optional OUTPUT structure, provides rows read, rows rejected, etc.
      0                     ,   //  pWorkDirectoryList, List of temporary directories for sort.
      0                     ,   //  pCopyTargetList,    List of target paths for any copy images.
      0                     ,   //  pNullIndicators,    List of which columns are NULLABLE.
      pvReserved            ,   //  Reserved for future use
    & sqlca                     //  Address of the GLOBAL VARIABLE structure sqlca sqlca.
    ) ;

  //  Throw an exception if we obtained an SQL error
  CHECK_SQL_CODE () ;

  //  If no exception was thrown, inform user as to the success of the operation
  cout  << "LOAD complete, " << sqluloadOutputInfo.rowsRead << " Rows were read\n"
        << sqluloadOutputInfo.rowsCommitted << " Rows were committed to the table\n" 
        "SQL CODE is : " << sqlca.sqlcode << '\n' << endl ;

  return  sqlca.sqlcode ;

} /* long sqlLoadDelim ( char * , char * , char * , char * ) */



void initLoadInputStructure ( sqluload_in & rsqluloadInputInfo )
{
  memset ( & rsqluloadInputInfo , 0 , sizeof ( sqluload_in ) ) ;

  rsqluloadInputInfo.sizeOfStruct  = SQLULOAD_IN_SIZE ; //  This should never change
  rsqluloadInputInfo.restartphase  = ' '              ; //  Ignored anyway, but must be ' ' , L , B or D
  rsqluloadInputInfo.statsopt      = SQLU_STATS_NONE  ; //  We will get these later with DBMAINT

} /* void initLoadInputStructure ( sqluload_in & rsqluloadInputInfo ) */



void initLoadOutputStructure ( sqluload_out & rsqluloadOutputInfo )
{
  memset ( & rsqluloadOutputInfo , 0 , sizeof ( sqluload_out ) ) ;

  rsqluloadOutputInfo.sizeOfStruct = SQLULOAD_OUT_SIZE ;

} /* void initLoadOutputStructure ( sqluload_out & rsqluloadOutputInfo ) */

