/*************************************************************************
 
    FILE NAME :
     SQLCOM.CPP
 
 
 
    $Archive: $
 
    $Author: $
 
    $Date: $
 
    $Revision: $
 
    $Workfile: $
 
 
    DESCRIPTION :
      This module contains some general CPP functions that do not contain any SQL for use with DB2
 
 
    HISTORY :
 
 
    FUNCTIONS DEFINED IN THIS MODULE :
      long  sqlDropTable      ( const char  * cszTableName    ) ;
      long  sqlEmptyTable     ( const char  * cszTable        ) ;
      long  sqlImmediate      ( const char  * cszFormat , const char * cszTable ) ;
      int   sqlIsEmpty        ( const char  * cszTable        ) ;
      long  sqlLockTable      ( const char  * cszTable        ) ;
      long  sqlRebind         ( const char  * cszPackageName  ) ;
      long  sqlRunStats       ( const char  * cszTableName    ) ;
 
 
    $Log : $
 
************************************************************************/
//  System Defined C Headers
# include <stdio.h>
# include <string.h>
# include <time.h>


# include <sqlenv.h>
# include <sqlca.h>
# include <sqlutil.h>


//  System Defined C++ Headers
# include <iostream.h>


//  IBM OCL Defined C++ Headers
# include <iexcbase.hpp>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <sqlerror.hpp>
# include <db2error.hpp>
# include <showexp.hpp>
# include <sqldefs.hpp>
# include <sqlfcns.hpp>




const char  * cszGblConnectStmt     = "CONNECT TO %s IN SHARE MODE"     ;
const char  * cszGblDisconnectStmt  = "DISCONNECT %s"                   ;
const char  * cszGblDropStmt        = "DROP TABLE  %s"                  ;
const char  * cszGblEmptyStmt       = "DELETE FROM %s"                  ;
const char  * cszGblLockStmt        = "LOCK TABLE %s IN EXCLUSIVE MODE" ;


extern struct sqlca sqlca ;




/*************************************************************************
 
  TITLE :
    long sqlDropTable ( const char * cszTable )  (DYNAMIC SQL)
 
 
  ARGUMENTS :
    const char  * cszTable
      The ASCIIZ string containing the name of the table to drop.
 
 
  RETURNS :
    The sqlca.sqlcode that was retrieved when the database was called
    A value less than 0 indicates an error.  A value greater than 0
    usually indicates a warning.
 
 
  DESCRIPTION :
    This function drops the table named in the argument 'szTable'
    from the Database.
 
************************************************************************/
long sqlDropTable ( const char * cszTable )
{
  return sqlImmediate ( cszGblDropStmt , cszTable ) ;

} /*  long sqlDropTable ( const char * cszTable )  */



/*************************************************************************
 
  TITLE :
    long sqlEmptyTable ( const char * cszTable )  (DYNAMIC SQL)
 
 
  ARGUMENTS :
    const char  * cszTable
      The ASCIIZ string containing the name of the table to empty.
 
 
  RETURNS :
    The sqlca.sqlcode that was retrieved when the database was called
    A value less than 0 indicates an error.  A value greater than 0
    usually indicates a warning.
 
 
  DESCRIPTION :
    This function deletes all rows in (empties) the tables whose name is
    supplied in the argument 'szTable'.
 
************************************************************************/
long sqlEmptyTable ( const char * cszTable )
{
  return sqlImmediate ( cszGblEmptyStmt , cszTable ) ;

} /*  long sqlEmptyTable ( const char * cszTable )  */



/*************************************************************************
 
  TITLE :
    int sqlIsEmpty ( const char * cszTable )  (DYNAMIC SQL)
 
 
  ARGUMENTS :
    const char  * cszTable
      The ASCIIZ string containing the name of the table to check.
 
 
  RETURNS :
    TRUE if table is EMPTY.
    FALSE if table is not.
 
 
  DESCRIPTION :
    This function sees if there are any rows the table whose name is
    supplied in the argument 'cszTable'.
 
************************************************************************/
int sqlIsEmpty ( const char * cszTable )
{
  unsigned long ulNumRows ;

  sqlGetNumRows ( cszTable , & ulNumRows ) ;

  ulNumRows = ulNumRows == 0 ? 1 : 0 ;

  return (int) ulNumRows ;

} /*  int sqlIsEmpty ( const char * cszTable )  */



/*************************************************************************
 
  TITLE :
    size_t sqlLoadStatement
        (
        char        * szStatement ,
        const char  * cszFormat   ,
        const char  * cszTable
        ) ;
 
 
  ARGUMENTS :
    char        * szStatement
      The address of the DESTINATION var char structure.  This must be
      declared in such a way that in can hold a string equal to the length
      of the argument 'szFormat' + 'szTable'
 
    const char  * cszFormat
      The address of the Format String.  This will used as the format to 
      sprintf into the  string variable.
 
    const char  * cszTable
      This is the argument that will be sprintf into szStatement.  See the
      description section for an example.
 
  RETURNS :
    The number of bytes copied, i.e the size of the string held by
    'szStatement'.
 
 
  DESCRIPTION :
    This function is intended to copy a 2 part SQL Statement into a host 
    variable.  For example one might call :
 
      loadSQLStatment ( & hvSQL , "DELETE FROM %s " , "MY_TABLE" ) ;
 
    Upon return , hvSQL will hold the string "DELETE FROM MY_TABLE".
 
************************************************************************/
size_t sqlLoadStatement
  (
  char        * szStatement ,
  const char  * cszFormat   ,
  const char  * cszTable
  )
{
  sprintf ( szStatement , cszFormat , cszTable ) ;

  return  strlen ( szStatement ) ;

} /*  size_t sqlLoadStatement ( char * , const char * , const char * )  */



/*************************************************************************
 
  TITLE :
    long sqlLockTable ( const char * cszTable ) ;
 
 
  ARGUMENTS :
 
    const char      * cszTable
      The name of the table as an ASCIIZ string.  This table will be locked
      in exclusive mode.
 
 
  RETURNS :
    The sqlca.sqlcode that resulted from the Database call,
 
 
  DESCRIPTION :
    This function obtains a full, exclusive table lock on the table named
    in the input argument : 'cszTable'.
 
************************************************************************/
long sqlLockTable ( const char * cszTable )
{
  return  sqlImmediate ( cszGblLockStmt , cszTable ) ;

} /* long sqlLockTable ( const char * cszTable ) */



/*************************************************************************
 
  TITLE :
    long sqlImmediate ( const char * cszFormat , const char * cszTable ) ;
 
 
  ARGUMENTS :
    const char      * cszFormat
      The address of the Format String.  This will used as the format to
      sprintf into the SQL Statement.
 
    const char      * cszTable
      This is the argument that will be sprintf into the SQL Statement.
      See the description section for an example.
 
 
  RETURNS :
    The sqlca.sqlcode that resulted from the Database call,
 
 
  DESCRIPTION :
    This function is intended to execute a 2 part SQL Statement
    Dynamically.  For example one might call :
 
      sqlImmediate ( "DELETE FROM %s " , "MY_TABLE" ) ;
 
    will cause the execution of "DELETE FROM MY_TABLE".
 
************************************************************************/
long sqlImmediate ( const char * cszFormat , const char * cszTable )
{
  char    szSQLStmt [MAX_SQL_STATMT] ;

  sqlLoadStatement ( szSQLStmt , cszFormat , cszTable ) ;

  return  sqlExecStatement ( szSQLStmt ) ;

} /*  long sqlImmediate ( const char * cszFormat , const char * cszTable )  */



/*************************************************************************
 
  TITLE :
    long sqlRebind ( const char * cszPackageName )
 
 
  ARGUMENTS :
    const char  * cszPackageName
      The ASCIIZ name of the package to be rebound.
 
 
  RETURNS :
    The sqlca.sqlcode resulting from the API call to sqlarbnd.
 
 
  DESCRIPTION :
    This function REBINDS the package named in the input parameter 
    'cszPackageName'.  THIS PACKAGE MUST EXIST OR AN EXCEPTION OF TYPE
    DB2ERROR WILL BE THROWN!!!
 
************************************************************************/
long sqlRebind ( const char * cszPackageName )
{
  //  This is needed because IBM didn't make the package name parameter to sqlarbnd a constant!
  //  Silly C programmers!!! (giggle, giggle)
  //  I DO know this is TERRIBLE programming practice to uncast constant!
  char  * szPackage = (char *) cszPackageName ;

  try
  {
    sqlarbnd ( szPackage , & sqlca , 0 ) ;

    CHECK_SQL_CODE () ;

  } /* endtry */
  catch ( SQLException & rsqlerror )
  {
    //  We do not care if the rebind fails, so catch any exceptions thrown from sqlRebind, and show the operator a
    //  message that the package bind failed, but proceed.
    cerr  <<  rsqlerror ;
    cerr  <<  "Program could not bind package " << cszPackageName << " Programming continuing Normally\n" ;

  } /* endcatch ( SQLException & rsqlerror ) */

  return sqlca.sqlcode ;

} /* long sqlRebind ( const char * cszPackageName ) */



/*************************************************************************
 
  TITLE :
    long sqlRunStats ( const char * cszTableName , int nOpt )
 
 
  ARGUMENTS :
    const char  * cszTableName
      The ASCIIZ name of the table against whom statistics are to be collected.
 
    int           nOpt
      The options level as defined in <sqlutil.h>.  This should be in the set  :
         {
            SQL_STATS_TABLE, SQL_STATS_BOTH, SQL_STATS_INDEX, SQL_STATS_EXTTABLE_ONLY,
            SQL_STATS_EXTINDEX_ONLY, SQL_STATS_EXTTABLE_INDEX, SQL_STATS_EXTINDEX_TABLE,
            SQL_STATS_ALL 
          }
 
 
  RETURNS :
    The sqlca.sqlcode resulting from the API call to sqlustat.
 
 
  DESCRIPTION :
    This function runs extended for the table named in the input parameter
    'cszTableName' using the statistics option level defined in 'nOpt'
 
************************************************************************/
long sqlRunStats ( const char * cszTableName , int nOpt )
{
  //  This is needed because IBM didn't make the package name parameter to sqlarbnd a constant!
  //  Silly C programmers!!! (giggle, giggle)
  //  I DO know this is TERRIBLE programming practice to uncast constant!
  char  * szTable = (char *) cszTableName ;

  sqlustat ( szTable , 0 , 0 , (unsigned char) nOpt , SQL_STATS_REF , & sqlca ) ;

  RETURN_SQL_CODE () ;

} /* long sqlRunStats ( const char * cszTableName , int nOpt ) */





/*************************************************  END OF FILE SQLCOM.CPP    ************************************************/
