/***************************************************************************************************************************
 
    FILE NAME :
      SQLCLASS.CPP
 
 
    APPLICATION :
      GENERAL, THIS MODULE WILL BE USED BY ALL APPLICATIONS USING THE DESCENDENTS OF ANY OF THE ABSTRACT CLASSES
      DECLARED IN "SQLCLASS.HPP"
 
 
    $Archive: $
 
    $Author:   PGARNER  $
 
    $Date: $
 
    $Revision: $
 
    $Workfile: $
 
 
    $Log: $


    DESCRIPTION :
      This module contains the C++ source for the methods used to implement the abstract SQLCursor class declared in
      SQLCLASS.HPP.
 
 
***************************************************************************************************************************/
//  System Defined C Headers
# include <stddef.h>


//  DB2 Defined C Headers
# include <sqlca.h>


//  IBM OCL Defined C++ Headers
# include <ibase.hpp>
# include <iexcbase.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <sqlerror.hpp>
# include <db2error.hpp>
# include <sqlclass.hpp>







/***************************************************************************************************************************
  TITLE       :
    long SQLCursor :: fetch ( char * szData )


  ARGUMENTS   :
    char  * szData
      A pointer to a character array that (if it is not null) will hold the data retrieved by the cursor fetch.
      This argument may be 0 (NULL) and if it IS 0, only a simple database fetch is performed, and no data will
      be copied.


  RETURNS     :
    The sqlca.sqlcode associated with the last call to the database.


  DESCRIPTION :
    This method calls the 2 pure virtual methods 'fetchDBData ()' and 'copyRow ( char * )' to fetch the next
    row from the cursor.  These 2 pure virtual methods are to be defined by the child classes.  The general
    intention is that 'fetchDBData' will fetch the data from the defined cursor into the appropriate host
    variables.  'copyRow' will then copy that data into the argument 'szData' as an ASCIIZ string.  The actual
    format of the string thus produced is dependant upon how the descendent class refines 'copyRow'.


  EXCEPTIONS  :
    If any SQL errors or warnings are encountered while the database fetch attempt is being made, an exception
    of the type appropriate to the database will be thrown.

***************************************************************************************************************************/
long SQLCursor :: fetch ( char * szData )
{
  //  Do the actual fetch from the cursor
  long  lRet  = fetchDBData ()  ;

  //  Copy the data fetched from the host variables in the manner defined by the child class.
  copyRow ( szData ) ;

  return  lRet ;

} /* long SQLCursor :: fetch ( char * szData ) */



/***************************************************************************************************************************
  TITLE       :
    long SQLCursor :: open ()


  RETURNS     :
    The sqlca.sqlcode associated with the last call to the database.


  DESCRIPTION :
    This method does not actually open anything.  This should be a PROTECTED virtual method and the sole
    purpose is to place all of the error checking and housekeeping associated with opening a cursor in a single
    method in the parent class.  All this really does is check the sqlca.sqlcode to see if an error or warning
    occured.  It creates an appropriate Exception Object using that SQLCA, closes the cursor (close is defined as
    virtual, so the appropriate close method will be called.) then throws that error object.  In this way we
    can redefine the child open to open the actual cursor being declared, then do all of the housekeeping from
    this method.


  EXCEPTIONS  :
    If any SQL errors or warnings are encountered, an exception of the type appropriate to the database will
    be thrown.

***************************************************************************************************************************/
long SQLCursor :: open ()
{
  //  This method is intended to be called AFTER the child class class open.  The first thing we must do is check to see
  //  if the child open failed!
  if ( fail () )
  {
    //  Load our SQLException object with the appropriate information
    loadSQLError () ;

    try
    {
      close () ;      

    } /* endtry */
    catch ( SQLException & rsqlerror )
    {
      //  Do nothing, this is just to prevent the 'close ()' from throwing ANOTHER sqlError out of this method!
      //  Note we are only catching SQLExceptions, if 'close ()' throws an Exception, we do not want to catch it!
      //  Also note that if we do catch a SQLException, we append its' error message to the error object we have
      //  already created.
      getSQLError ().appendText ( rsqlerror.text () ) ;

    } /* endcatch ( SQLException ) */

    throw getSQLError () ;

  } /* endif */

  return  warning () ;

} /* long SQLCursor :: open () */



/************************************************   END OF FILE SQLCLASS.CPP   ********************************************/
