/*************************************************************************************************************
 
    FILE NAME :
      REBIND.CPP
 
 
    APPLICATION :
      GENERAL UTILITIES METHODS TO REBIND DATABASE PACKAGES
 
 
    $Archive: $
 
    $Author:   PGARNER  $
 
    $Date: $
 
    $Revision: $
 
    $Workfile: $
 
 
 
    $Log: $
 
 
 
    DESCRIPTION :
      This module contains some methods used exclusively to rebind database packages.
      
 
    METHODS DEFINED IN THIS MODULE AND IN SQLFCNS.HPP (INTENDED EXTERNAL ENTRY POINTS) :
      int       rebindAllPackages     ()  ;
 
    METHODS DEFINED IN THIS MODULE FOR THIS MODULES INTERNAL USE ONLY :
      IBoolean  rebind                ( const IString & rcistrPackageName , void   pvDummy )
 
*************************************************************************************************************/
//  DB2 Defined C Headers
# include <sqlenv.h>
# include <sqlca.h>
# include <sqlcodes.h>
# include <sqlutil.h>


//  System Defined C++ Headers
# include <iostream.h>


//  IBM OCL Defined C++ Headers
# include <iexcbase.hpp>
# include <isrtset.h>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <showexp.hpp>
# include <sqlerror.hpp>
# include <db2error.hpp>
# include <sqldefs.hpp>
# include <sqlfcns.hpp>
# include <sqlclass.hpp>
# include <sortstrn.hpp>
# include <packcurs.hpp>    //  Gets the declaration for 'getAllPackages'






//  This is an iterator function for the collection of package names.  The void parameter is required by the
//  IBM specification for these classes but we neither use nor need it here, hence the name pvDummy!
//  Note that this function is not intended to be called outside of 'int rebindAllPackages ()' so it is not
//  declared in "DBMAINT.SQX"!
IBoolean  rebind  ( const IString & rcistrPackageName , void  * pvDummy = 0 ) ;




/**************************************************************************************************************
 
  TITLE :
    int rebindAllPackages ()


  ARGUMENTS :
    const char * cszPkgSchema
      The schema whose packages we wish to rebind, this defaults to USERID
     
 
  RETURNS :
    The number of packages rebound
 
 
  DESCRIPTION :
    This function rebinds all database packages.  The intention of this function is is to replace "DBMAINT.CMD"
    with something that will rebind ALL packages, not just the old "DB2RTNS.BND".  Note that the "*.BND" files
    are not needed when REBINDING.
 
*************************************************************************************************************/
int rebindAllPackages ( const char * cszPkgSchema )
{
  //  Create a sorted string container to hold the package names.  Note that this need not be a SORTED
  //  string container, but since we already have that class defined elsewhere, why not use it?
  SortedIStrings  sortistrgPackages ;

  //  Initialized Data
  long            lRet      = 0     ;

  //  This utility (non-member function) retreives all of the current database package names into its SortedStrings &
  //  argument.  This method (getAllPackages) is defined in PACKCURS.SQX.
  getAllPackages  ( sortistrgPackages ) ;

  //  Since we have ALL of the package names, invoke rebind on each package name.
  sortistrgPackages.allElementsDo ( rebind ) ;

  cout  << "Successfully rebound ALL USER packages\n" << endl ;

  return  sortistrgPackages.numberOfElements () ;

} /* int rebindAllPackages () */



/**************************************************************************************************************
 
  TITLE         :
    IBoolean rebind ( const IString & rcistrPackageName , void * pvDummy )

  ARGUMENTS     :
    const IString & rcistrPackageName
      The name of the package to be bound in the form "schema.packagename".  If the schema is not supplied,
      an attempt will be made to find the package in the current default schema.  If the package cannot be
      found, a DB2Error will be thrown.

    void          * pvDummy
      This is an unused parameter.  However the declarations for the IBM OCL collection classes require that
      a void pointer be passed to all iterator functions as the last parameter.  This allows one to increase
      the utility of such iterators, be we simply do not need it.  Note this parameter defaults to 0.
 
  RETURNS       :
    true - This is required by the iterator.  If the function returns false, the iterator takes that as an
    error condition and stops iterating.
 
 
  DESCRIPTION   :
    This function rebinds a single database package.  This function calls our method 'sqlRebind', a non member
    function that rebinds a single package.  This function is intended for use with the OCL Collection class
    iterator "allElementsDo".  Note that IS how this function is used in "int rebindAllPackages ()", via the
    statement "sortstrPackages.allElementsDo ( rebind ) ;"  Please see the IBM OCL documentation for more
    information on OCL collection classes and iterators.
 
*************************************************************************************************************/
IBoolean rebind ( const IString & rcistrPackageName , void * pvDummy )
{
  //  Rebind the package named in rcistrPackageName using our sqlRebind method
  long  lRet = sqlRebind ( (const char *) rcistrPackageName ) ;

  //  If the rebind was successful, tell the user
  if ( 0 ==lRet )
  {
    cout  << "Successfully rebound package : " << rcistrPackageName << endl ;

  } /* endif */

  return  true  ;

} /* IBoolean rebind ( const IString & rcistrPackageName , void * pvDummy ) */




/*************************************************  END OF FILE REBIND.CPP  ***********************************************/
