/***************************************************************************************************************************
 
    FILE NAME :
      DB2CURSR.CPP
 
 
    APPLICATION :
      GENERAL, THIS MODULE IMPLEMENTS THE DB2CURSOR SUPERCLASS AND IS USED BY ALL CODE INSTANTIATING A DESCENDENT
      OF THE CLASS DB2CURSOR
 
 
    $Archive: $
 
    $Author:   PGARNER  $
 
    $Date: $
 
    $Revision: $
 
    $Workfile: $
 
 
    $Log: $


    DESCRIPTION :
      This module contains the C++ source for the methods used to implement the abstract DB2Cursor class.
 
 
***************************************************************************************************************************/
//  System Defined C Headers
# include <stddef.h>


//  DB2 Defined C Headers
# include <sqlca.h>


//  IBM OCL Defined C++ Headers
# include <ibase.hpp>
# include <iexcbase.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <sqlerror.hpp>
# include <sqldefs.hpp>
# include <sqlclass.hpp>
# include <db2error.hpp>
# include <db2cursr.hpp>







/***************************************************************************************************************************
  TITLE       :
    DB2Cursor :: DB2Cursor ()


  DESCRIPTION :
    This method constructs a DB2Cursor Object and initializes it's internal data.

***************************************************************************************************************************/
DB2Cursor :: DB2Cursor () : db2errorInternal ( 0 , 0 )
{

} /* DB2Cursor :: DB2Cursor () */



/***************************************************************************************************************************
  TITLE       :
    IBoolean DB2Cursor :: fail () const


  RETURNS     :
    True is an error is associated with the receiver's last database access
    False otherwise


  DESCRIPTION :
    This method checks the receivers' sqlca.sqlcode to see if a database access has failed.


***************************************************************************************************************************/
IBoolean DB2Cursor :: fail () const
{
  //  Return true if the SQLCODE < 0 (error condition)
  return  sqlca.sqlcode < 0 ? true : false ;

} /* IBoolean DB2Cursor :: fail () const */



/***************************************************************************************************************************
  TITLE       :
    DB2Error & DB2Cursor :: getDB2Error ()


  RETURNS     :
    A reference to the receiver's internal DB2Error Object.


  DESCRIPTION :
    This method returns a reference to the receiver's internal DB2Error Object.


***************************************************************************************************************************/
DB2Error & DB2Cursor :: getDB2Error ()
{
  return  db2errorInternal ;

} /* DB2Error & DB2Cursor :: getDB2Error () */



/***************************************************************************************************************************
  TITLE       :
    SQLException & DB2Cursor :: getSQLError ()


  RETURNS     :
    A reference to the receiver's internal SQLException Object.


  DESCRIPTION :
    This method returns a reference to the receiver's internal SQLException Object.


***************************************************************************************************************************/
SQLException & DB2Cursor :: getSQLError ()
{
  return  getDB2Error () ;

} /* SQLException & DB2Cursor :: getSQLError () */



/***************************************************************************************************************************
  TITLE       :
    const SQLException & DB2Cursor :: loadSQLError ()


  RETURNS     :
    A reference to the receiver's internal SQLException Object.


  DESCRIPTION :
    This method initializes the receiver's internal SQLException Object based on the data in the receiver's internal
    sqlca struct.


***************************************************************************************************************************/
const SQLException & DB2Cursor :: loadSQLError ()
{
  getDB2Error ().init ( & sqlca ) ;

  return  getDB2Error () ;

} /* const SQLException & DB2Cursor :: loadSQLError () */



/***************************************************************************************************************************
  TITLE       :
    unsigned long DB2Cursor :: warning () const


  RETURNS     :
    The warning code if there IS a warning associated with the receiver,
    0 otherwise.


  DESCRIPTION :
    This method returns a long SQL Warning Code.  If there is no warning associated with the receiver, this method returns
    0.  This method is used to check for warning as opposed to error conditions within the receiver.

***************************************************************************************************************************/
unsigned long DB2Cursor :: warning () const
{
  //  Return a warning only if it is > 0, i.e. is a warning, not an error!
  return  sqlca.sqlcode > 0 ? sqlca.sqlcode : 0 ;

} /* unsigned long DB2Cursor :: warning () const */




/************************************************   END OF FILE DB2CURSR.CPP   ********************************************/
