/***************************************************************************************************************************
 
    FILE NAME   :
      TABLEOBJ.CPP


    AUTHOR      :
      PETER GARNER


    DESCRIPTION :
    This module implements the interface for the class TableObject, an abstract super class that represents a Database
    Table.

 
    METHODS DEFINED IN THIS MODULE :
      TableObject :: TableObject ()

      const char    * TableObject :: className    ()  const
      void            TableObject :: clear        ()
      long            TableObject :: lastSQLCode  ()  const
      const char    * TableObject :: lastSQLStat  ()  const
      long            TableObject :: setSQLCode   ( long lSQLCode )
      const char    * TableObject :: setSQLStat   ( const char * cszSQLState )

***************************************************************************************************************************/
//  Locally Defined C++ Headers
# include <tableobj.hpp>    //  This include file includes the AIX semaphore includes, under AIX this must be included first
                            //  Under OS/2 it does not matter


//  Locally Defined C Headers
# include <strfcns.h>




/***************************************************************************************************************************
  TableObject :: TableObject ()
****************************************************************************************************************************

  DESCRIPTION :
    This method constructs a TableObject and sets the values returned by its' lastSQLCode () and lastSQLStat () methods
    to 0.

***************************************************************************************************************************/
TableObject :: TableObject ()
{
  //  Set the SQL Code and SQL State member to 0.
  clear () ;

} /* TableObject :: TableObject () */



/***************************************************************************************************************************
  const char * TableObject :: className () const
****************************************************************************************************************************

  RETURNS     :
    A constant pointer to the ASCIIZ string "TableObject".


  DESCRIPTION :
    This VIRTUAL constant method always returns the class name of the receiver.  This may be used to implement
    a primitive Run Time Type Identification, (RTTI), or anything else you like.  Note that this IS a virtual
    function, and will early bind in the constructors and destructor.  Thus you can also use this method to
    determine in which constructor level you are, although I don't know why you would want to know that!

***************************************************************************************************************************/
const char * TableObject :: className () const
{
  return  "TableObject" ;

} /* const char * TableObject :: className () const */



/***************************************************************************************************************************
  void TableObject :: clear ()
****************************************************************************************************************************

  DESCRIPTION :
    This method sets the receivers' internal Database variables to 0.  In the case of TableObject, this method sets the
    values returned by its' lastSQLCode () and lastSQLStat () methods to 0.

***************************************************************************************************************************/
void TableObject :: clear ()
{
  setSQLCode ( 0 ) ;
  setSQLStat ( 0 ) ;

} /* void TableObject :: clear () */



/***************************************************************************************************************************
  long TableObject :: lastSQLCode () const
****************************************************************************************************************************

  RETURNS     :
    The value of the SQL Code generated by the receivers' last database access
    

  DESCRIPTION :
    This is the accessor method for receivers' SQL Code, the value of the SQL Code generated by the receivers' last
    database access

***************************************************************************************************************************/
long TableObject :: lastSQLCode () const
{
  return  lSQLCodeLast ;

} /* long TableObject :: lastSQLCode () const */



/***************************************************************************************************************************
  const char * TableObject :: lastSQLStat () const
****************************************************************************************************************************

  RETURNS     :
    The value of the SQL Stat generated by the receivers' last database access as a constant ASCIIZ string.


  DESCRIPTION :
    This is the accessor method for receivers' SQL Stat, the value of the SQL Stat generated by the receivers' last
    database access

***************************************************************************************************************************/
const char * TableObject :: lastSQLStat () const
{
  return  szSQLStatLast ;  

} /* const char * TableObject :: lastSQLStat () const */



/***************************************************************************************************************************
  long TableObject :: setSQLCode ( long lSQLCode )
****************************************************************************************************************************

  ARGUMENTS   :
    long  lSQLCode
      The input value to which to set the value returned by the receivers' lastSQLCode () method.  This SHOULD be either 0,
      or the SQL Code value generated by the receivers' last attempt at database access.


  RETURNS     :
    The value of the input argument 'lSQLCode'.


  DESCRIPTION :
    This is the PROTECTED accessor method that sets the value returned by the receivers' lastSQLCode () method.

***************************************************************************************************************************/
long TableObject :: setSQLCode ( long lSQLCode )
{
  return  lSQLCodeLast = lSQLCode ;

} /* long TableObject :: setSQLCode ( long lSQLCode ) */



/***************************************************************************************************************************
  const char * TableObject :: setSQLStat ( const char * cszSQLState = 0 )
****************************************************************************************************************************

  ARGUMENTS   :
    const char * cszSQLState = 0
      The input value to which to set the value returned by the receivers' lastSQLStat () method.  This SHOULD be either 0,
      or the SQL Stat value generated by the receivers' last attempt at database access.


  RETURNS     :
    The NEW value of the SQL State as a constant ASCIIZ string.


  DESCRIPTION :
    This is the PROTECTED accessor method that sets the value returned by the receivers' lastSQLStat () method.

***************************************************************************************************************************/
const char * TableObject :: setSQLStat ( const char * cszSQLState )
{
  //  Copy the argument into the member
  strTermFill ( szSQLStatLast , cszSQLState , 0 , sizeof ( szSQLStatLast ) ) ;

  return  lastSQLStat () ;

} /* const char * TableObject :: setSQLStat ( const char * cszSQLState ) */




/*********************************************   END OF FILE TABLEOBJ.CPP   ***********************************************/
