//  System Defined C Headers
# include <stdlib.h>


//  System Defined C++ Headers
# include <fstream.h>


//  IBM OCL Defined C++ Headers
# include <iexcept.hpp>


//  Locally Defined C++ Headers
# include <tablecol.hpp>



const int   cnCOLUMN_START    =  7  ;
const int   cnTYPE_START      = 33  ;
const int   cnSIZE_START      = 45  ;
const int   cnNULL_START      = 55  ;
const int   cnCOMMA_START     = 65  ;







TableColumn :: TableColumn ()
  : uColumnNumber   ( 0 )               ,
    uLength         ( 0 )               ,
    uScale          ( 0 )               ,
    columntype      ( "" , enUNKNOWN )  ,
    uDisplayLength  ( 0 )               ,
    bRequired       ( false )
{

} /* TableColumn :: TableColumn () */



TableColumn :: TableColumn ( const TableColumn & crtablecolumn )
{
  init  ( crtablecolumn ) ;

} /* TableColumn :: TableColumn ( const TableColumn & crtablecolumn ) */



unsigned TableColumn :: columnLength () const
{
  return  uLength ;

} /* unsigned TableColumn :: columnLength () const */



const char * TableColumn :: columnName () const
{
  return  istrgColumnName ;  

} /* const char * TableColumn :: columnName () const */



unsigned TableColumn :: columnNumber () const
{
  return  uColumnNumber ;

} /* unsigned TableColumn :: columnNumber () const */



unsigned TableColumn :: columnScale () const
{
  return  uScale ;

} /* unsigned TableColumn :: columnScale () const */



const char * TableColumn :: columnType () const
{
  return  columntype ;

} /* const char * TableColumn :: columnType () const */



SQLDataType TableColumn :: dataType () const
{
  return  (SQLDataType) columntype.key () ;

} /* SQLDataType TableColumn :: dataType () const */



unsigned TableColumn :: displayLength () const
{
  return  uDisplayLength ;

} /* unsigned TableColumn :: displayLength () const */



const IString & TableColumn :: format ( IString & ristrg ) const
{ 
  IString   istrgLength  ;

  //  Initialize input string to a blank string
  ristrg  = IString ( "" ) ;

  //  Overlay the input string with the column data at the specified locations
  ristrg.overlayWith ( columnName ()  , cnCOLUMN_START  ) ;
  ristrg.overlayWith ( columnType ()  , cnTYPE_START    ) ;

  //  If a NOT NULL field
  if ( ! isNullable () )
  {
    ristrg.overlayWith ( "NOT NULL" , cnNULL_START ) ;

  } /* endif */

  switch ( dataType () )
  {
    case  enCHAR    :
    case  enVARCHAR :    
      istrgLength = IString ( '(' ) + IString ( columnLength () ) + IString ( ')' ) ;
      ristrg.overlayWith    ( istrgLength , cnSIZE_START ) ;
      break ;

    case  enFIXED   :
    case  enFLOAT   :
      istrgLength = IString ( '(' ) + IString ( uLength ) + IString ( ',' ) + IString ( uScale ) + IString ( ')' ) ;
      ristrg.overlayWith    ( istrgLength , cnSIZE_START ) ;
      break ;

  } /* endswitch */

  ristrg.overlayWith ( ",\n" , cnCOMMA_START ) ;

  return  ristrg ;

} /* const IString & TableColumn :: format ( IString & ristrg ) const */



const char * TableColumn :: className () const
{
  return  "TableColumn" ;

} /* const char * TableColumn :: className () const */



unsigned TableColumn :: init ( const TableColumn & crtablecolumn )
{
  return  init
            (
            crtablecolumn.columnNumber  ()  ,
            crtablecolumn.columnName    ()  ,
            crtablecolumn.dataType      ()  ,
            crtablecolumn.columnLength  ()  ,
            crtablecolumn.columnScale   ()  ,
            crtablecolumn.isNullable    ()  ,
            crtablecolumn.displayLength ()
            ) ;

} /* unsigned TableColumn :: init ( const TableColumn & crtablecolumn ) */



unsigned TableColumn :: init
      (
      unsigned      uColNo        ,
      const char  * cszColName    ,
      const char  * cszColType    ,
      unsigned      uColLength    ,
      unsigned      uColScale     ,
      char          cNullable     ,  // (Y or N)
      unsigned      uDisplayLength
      )
{
  ColumnInfoTranslator  colinfotranslator  ;

  SQLDataType sqldatatype = colinfotranslator.fromString ( cszColType ) ;

  return  init
            (
            uColNo        ,
            cszColName    ,
            sqldatatype   ,
            uColLength    ,
            uColScale     ,
            cNullable     ,
            uDisplayLength 
            ) ;

} /* unsigned TableColumn :: init ( unsigned , const char * , const char * , unsigned , unsigned , IBoolean ) */



unsigned TableColumn :: init
      (
      unsigned        uColNo      ,
      const char    * cszColName  ,
      SQLDataType     sqldtypeCol ,
      unsigned        uColLength  ,
      unsigned        uColScale   ,
      Boolean         bNullable   ,
      unsigned        uDisplayLen
      )
{
  ColumnInfoTranslator  colinfotrans  ;

  ColumnTypePair  coltypepair  ( colinfotrans.toString ( sqldtypeCol )  , sqldtypeCol ) ;

  uColumnNumber   = uColNo        ;
  istrgColumnName = cszColName    ;
  columntype.init ( coltypepair ) ;
  uLength         = uColLength    ;
  uScale          = uColScale     ;
  bRequired       = ! bNullable   ;
  uDisplayLength  = uDisplayLen   ;

  return  uColNo ;

} /* unsigned TableColumn :: init ( unsigned , const char * , SQLDataType , unsigned , unsigned , IBoolean , long ) */



Boolean TableColumn :: isNullable () const
{
  return  ! bRequired ;

} /* Boolean TableColumn :: isNullable () const */



unsigned const & TableColumn :: key () const
{
  return  uColumnNumber ;

} /* unsigned const & TableColumn :: key () const */




unsigned const & key ( const TableColumn & rctablecolumn )
{
  return  rctablecolumn.key () ;

} /* unsigned const & key ( const TableColumn & rctablecolumn ) */
