/***************************************************************************************************************************
 
    FILE NAME :
      SQLERROR.CPP
 
 
    APPLICATION :
      GENERAL, THIS IMPLEMENTS AN ABSTRACT BASE CLASS "SQLEXCEPTION" (DECLARED IN "SQLERROR.HPP") THAT IS USED AS AN
      EXCEPTION OBJECT THAT IS PORTABLE BETWEEN THE VARIOUS RDBMS
 
 
    DESCRIPTION :
      This module contains the C++ source for the methods used to implement the abstract SQLException class declared in
      "SQLERROR.HPP".
 
 
***************************************************************************************************************************/
//  System Defined C Headers
# include <errno.h>
# include <stddef.h>


//  DB2 Defined C Headers
# include <sqlca.h>


//  Locally Defined C++ Headers
# include <sqlerror.hpp>




/***************************************************************************************************************************
  TITLE       :
    SQLException :: SQLException ( const SQLException & rcsqlexception )


  ARGUMENTS   :
    const SQLException  & rcsqlexception
      A constant reference to an SQLException object.  This object will be the SOURCE for the deep copy

  DESCRIPTION :
    This is the COPY constructor for an SQLException.  This constructor creates a DEEP copy of the argument 'rcsqlexception'.

***************************************************************************************************************************/
SQLException :: SQLException ( const SQLException & rcsqlexception ) : IInvalidRequest ( rcsqlexception )
{
  //  Parent Constructor will do all the needed work!

} /* SQLException :: SQLException ( const SQLException & rcsqlexception ) */



/***************************************************************************************************************************
  TITLE       :
    SQLException :: SQLException ( const char * cszMsg , unsigned long ulErrID )


  ARGUMENTS   :
    const char          * cszMsg
      A pointer to an ASCIIZ string containing any error messages we wish to pass (may be NULL)

    unsigned long         ulErrID
      The primary error code as a long unsigned int


  DESCRIPTION :
    This is another constructor for an SQLException.  This class should the parent of all our SQLException objects.  I.e. we
    should derive further exception classes that are specialized for a particular database (such as SQLException) from this
    class as needed.

***************************************************************************************************************************/
SQLException :: SQLException ( const char * cszMsg , unsigned long ulErrID ) : IInvalidRequest ( cszMsg , ulErrID )
{

} /* SQLException :: SQLException ( const char * cszMsg , unsigned long ulErrID ) */



/***************************************************************************************************************************
  TITLE       :
    const char * SQLException :: className () const


  RETURNS     :
    A constant pointer to the ASCIIZ string "SQLException".


  DESCRIPTION :
    This VIRTUAL constant method always returns the class name of the receiver.  This may be used to implement
    a primitive Run Time Type Identification, (RTTI), or anything else you like.  Note that this IS a virtual
    function, and will early bind in the constructors and destructor.  Thus you can also use this method to
    determine in which constructor level you are, although I don't know why you would want to know that!

***************************************************************************************************************************/
const char * SQLException :: className () const
{
  return  "SQLException" ; 

} /* const char * SQLException :: className () const */

           

/***************************************************************************************************************************
  const char * SQLException :: name () const
****************************************************************************************************************************

  RETURNS     :
    A constant pointer to the ASCIIZ string "SQLException".


  DESCRIPTION :
  This method overides the IException name method defined by OCL so that it returns our NamedObject :: className method.
  I.e. this method overloads IException :: name so that it returns a value identical to NamedObject :: className.

***************************************************************************************************************************/
const char * SQLException :: name () const
{
  return  className () ;

} /* const char * SQLException :: name () const */




/************************************************   END OF FILE SQLERROR.CPP   ********************************************/
