/***************************************************************************************************************************
 
    FILE NAME :
      ERRTEXT.C
 
 
    DESCRIPTION :
      This module contains the function db2ErrorText.  This method constructs an error message given a pointer to a DB2
      sqlca structure
 
 
    METHODS DEFINED IN THIS MODULE :
      long db2ErrorText ( char * szErrBuff , struct sqlca * psqlca )
 
 
***************************************************************************************************************************/
/*  System Defined C Headers  */
# include <string.h>


/*  DB2 Defined C Headers  */
# include <sql.h>


/*  Locally Defined C Headers  */
# include <errtext.h>




/***************************************************************************************************************************
  TITLE       :
    long db2ErrorText ( char * szErrBuff , struct sqlca * psqlca )


  ARGUMENTS   :
    char          * szErrBuff
      The address of the buffer that will hold the error message as an ASCIIZ string.  This should be at least MAX_SQL_MSG
      + 1 (defined in "errtext.h" bytes long.)

    struct sqlca  * psqlca
      A pointer to the sqlca structure that was used in the database call that encountered the error we are examining.


  RETURNS
    The sqlca.sqlcode from the input argument 'struct sqlca * psqlca'


  DESCRIPTION :
    This method retrives the error text and sql state text associated with an sqlca structure and copies it to 'szErrBuff'.

***************************************************************************************************************************/
long db2ErrorText ( char * szErrBuff , struct sqlca * psqlca )
{
  /*  Uninitialized Data  */
  char  szStateBuff [MAX_SQL_MSG / 2 + 1] ;

  /*  Initialized Data    */
  int   nRet          = sqlaintp ( szErrBuff , MAX_SQL_MSG / 2 , MAX_SQL_LINE , psqlca ) ;

  /*  sqlaintp returns length of message string, so if nRet is 0, we have no error text!  */
  if ( 0 == nRet )
  {
    szErrBuff [0] = '\n' ;
    szErrBuff [1] = '\0' ;

  } /* endif */

  nRet = sqlogstt ( szStateBuff , MAX_SQL_MSG / 2 , MAX_SQL_LINE , psqlca -> sqlstate ) ;

  if ( 0 < nRet )
  {
    strcat ( szErrBuff , szStateBuff ) ;

  } /* endif */

  return  psqlca -> sqlcode ;

} /* long db2ErrorText ( char * szErrBuff , struct sqlca * psqlca ) */





/*******************************************   END OF FILE ERRTEXT.C   ****************************************************/
