//  System Defined C Headers
# include <stddef.h>


// Locally Defined C Headers
# include <strfcns.h>


//  System Defined C++ Headers
# include <iomanip.h>
# include <strstream.h>


//  IBM OCL Defined C++ Headers
# include <iexcept.hpp>
# include <istring.hpp>



// Locally Defined C++ Headers
# include <namedobj.hpp>
# include <sqlerror.hpp>
# include <db2error.hpp>
# include <dbinfo.hpp>






DBInfo :: DBInfo ( sqledinfo & rsqledinfo )
{
  memset  ( szDBAlias   , 0 , sizeof  ( szDBAlias   ) ) ;
  memset  ( szDBComment , 0 , sizeof  ( szDBComment ) ) ;
  memset  ( szDBDir     , 0 , sizeof  ( szDBDir     ) ) ;
  memset  ( szDBDrive   , 0 , sizeof  ( szDBDrive   ) ) ;
  memset  ( szDBName    , 0 , sizeof  ( szDBName    ) ) ;
  memset  ( szDBNode    , 0 , sizeof  ( szDBNode    ) ) ;
  memset  ( szDBType    , 0 , sizeof  ( szDBType    ) ) ;

  setDBAlias    ( rsqledinfo.alias    ) ;
  setDBComment  ( rsqledinfo.comment  ) ;
  setDBDir      ( rsqledinfo.intname  ) ;
  setDBDrive    ( rsqledinfo.drive    ) ;
  setDBName     ( rsqledinfo.dbname   ) ;
  setDBNode     ( rsqledinfo.nodename ) ;
  setDBType     ( rsqledinfo.dbtype   ) ;

} /* DBInfo :: DBInfo ( sqledinfo & rsqledinfo ) */



DBInfo :: DBInfo ( const DBInfo & crdbinfo )
{
  init  ( crdbinfo )  ;

} /* DBInfo :: DBInfo ( const DBInfo & crdbinfo ) */



const char * DBInfo :: className () const
{
  return  "DBInfo" ;

} /* const char * DBInfo :: className () const */



const char * DBInfo :: dbAlias () const
{
 return szDBAlias ;

} /* const char * DBInfo :: dbAlias () const */



const char * DBInfo :: dbComment () const
{ 
 return szDBComment ;

} /* const char * DBInfo :: dbComment () const */



const char * DBInfo :: dbDir () const
{
 return szDBDir ;

} /* const char * DBInfo :: dbDir () const */



const char * DBInfo :: dbDrive () const
{
  return szDBDrive ;

} /* const char * DBInfo :: dbDrive () const */



const char * DBInfo :: dbName () const
{
  return szDBName ;

} /* const char * DBInfo :: dbName () const */



const char * DBInfo :: dbNode () const
{
  return szDBNode ;

} /* const char * DBInfo :: dbNode () const */



const char * DBInfo :: dbType () const
{ 
  return szDBType ;

} /* const char * DBInfo :: dbType () const */



const IString & DBInfo :: getKey () const
{
  return  istrgKey  ;

} /* const IString & DBInfo :: getKey () const */



const DBInfo & DBInfo :: init ( const DBInfo & crdbinfo )
{
  setDBAlias    ( crdbinfo.dbAlias   ()  ) ;
  setDBComment  ( crdbinfo.dbComment ()  ) ;
  setDBDir      ( crdbinfo.dbDir     ()  ) ;
  setDBDrive    ( crdbinfo.dbDrive   ()  ) ;
  setDBName     ( crdbinfo.dbName    ()  ) ;
  setDBNode     ( crdbinfo.dbNode    ()  ) ;
  setDBType     ( crdbinfo.dbType    ()  ) ;

  return  * this ;

} /* const DBInfo & DBInfo :: init ( const DBInfo & crdbinfo ) */



const char * DBInfo :: infoAsString ( IString & ristrg ) const
{
  char        szInfo [cstGblMaxDBInfo + 1] ;
  ostrstream  ostrstrm  ( szInfo , cstGblMaxDBInfo ) ;

  memset  ( szInfo, 0 , sizeof ( szInfo ) ) ;
  ostrstrm.setf ( ios :: left ) ;
  ostrstrm  <<  setw  ( SQL_DBNAME_SZ + 1 ) << dbName     ()
            <<  setw  ( SQL_ALIAS_SZ  + 1 ) << dbAlias    ()
            <<  setw  ( SQL_CMT_SZ    + 1 ) << dbComment  ()
            <<  setw  ( SQL_NNAME_SZ  + 1 ) << dbNode     ()
            <<  setw  ( SQL_DRIVE_SZ  + 1 ) << dbDrive    ()
            <<  setw  ( SQL_INAME_SZ  + 1 ) << dbDir      ()
            <<  setw  ( SQL_DBTYP_SZ  + 1 ) << dbType     () << ends ;

  return  ristrg = IString ( ostrstrm.str () ) ;

} /* const IString & DBInfo :: infoAsString ( IString & ristrg ) const */



const char * DBInfo :: setDBAlias ( const char * cszAlias )
{
  return  strTermCpy  ( szDBAlias , cszAlias , sizeof ( szDBAlias ) - 1 ) ;

} /* const char * DBInfo :: setDBAlias ( const char * cszAlias ) */



const char * DBInfo :: setDBComment ( const char * cszComment )
{
  return  strTermCpy  ( szDBComment , cszComment , sizeof ( szDBComment ) - 1 ) ;

} /* const char * DBInfo :: setDBComment ( const char * cszComment ) */



const char * DBInfo :: setDBDir ( const char * cszDirectory )
{
  return  strTermCpy  ( szDBDir , cszDirectory , sizeof ( szDBDir ) - 1 ) ;

} /* const char * DBInfo :: setDBDir ( const char * cszDirectory ) */



const char * DBInfo :: setDBDrive ( const char * cszDrive )
{
  return  strTermCpy  ( szDBDrive , cszDrive , sizeof ( szDBDrive ) - 1 ) ;

} /* const char * DBInfo :: setDBDrive ( const char * cszDrive ) */



const char * DBInfo :: setDBName ( const char * cszName )
{
  strTermCpy  ( szDBName , cszName , sizeof ( szDBName ) - 1 ) ;

  istrgKey  = szDBName  ;

  return  szDBName  ;

} /* const char * DBInfo :: setDBName ( const char * cszName ) */



const char * DBInfo :: setDBNode ( const char * cszNode )
{
  return  strTermCpy  ( szDBNode , cszNode , sizeof ( szDBNode ) - 1 ) ;

} /* const char * DBInfo :: setDBNode ( const char * cszNode ) */



const char * DBInfo :: setDBType ( const char * cszType )
{
  return  strTermCpy  ( szDBType , cszType , sizeof ( szDBType ) - 1 ) ;

} /* const char * DBInfo :: setDBType ( const char * cszType ) */



const DBInfo & DBInfo :: operator = ( const DBInfo & crdbinfo )
{
  return  init  ( crdbinfo ) ;

} /* const DBInfo & DBInfo :: operator = ( const DBInfo & crdbinfo ) */



IString const & key ( const DBInfo & rcdbinfo )
{
  return  rcdbinfo.getKey () ;

} /* IString const & key ( const DBInfo & rcdbinfo ) */



long getAllDatabases ( KeySortedDBInfo & keysorteddbinfo )
{
   short                sIndex      ;
   struct   sqlca       sqlca       ;
   struct   sqledinfo * psqledinfo  ;
   unsigned short       usDBHandle  ;
   unsigned short       usDBCount   ;


  /*****************************************\
  * OPEN DATABASE DIRECTORY SCAN API called *
  \*****************************************/
  sqledosd ("\0", & usDBHandle, & usDBCount, & sqlca);

  if ( SQLE_RC_NODBDIR == sqlca.sqlcode )
  {
    return  SQLE_RC_NODBDIR ;

  }
  else
  {
    CHECK_SQL_CODE  ()  ;

  } /* endif */

  for ( sIndex = 0 ; sIndex < usDBCount ; sIndex++)
  {
    /************************************\
    * GET NEXT DATABASE ENTRY API called *
    \************************************/
    sqledgne ( usDBHandle , & psqledinfo , & sqlca ) ;

    CHECK_SQL_CODE  () ;

    DBInfo dbinfo ( * psqledinfo ) ;

    keysorteddbinfo.add ( dbinfo ) ;

  } /* endfor */

  /******************************************\
  * CLOSE DATABASE DIRECTORY SCAN API called *
  \******************************************/
  sqledcls ( usDBHandle, & sqlca ) ;

  RETURN_SQL_CODE () ;

} /* long getAllDatabases ( KeySortedDBInfo & keysorteddbinfo ) */



long getAllDatabaseInfo ( SortedIStrings & srtstrngset )
{
  int               n               ;
  IString           istrgInfo       ;
  KeySortedDBInfo   keysorteddbinfo ;
  long              lRetVal         ;

  lRetVal = getAllDatabases ( keysorteddbinfo ) ;

  for ( n = 1 ; n <= keysorteddbinfo.numberOfElements () ; n++ )
  {
    keysorteddbinfo.elementAtPosition ( n ).infoAsString ( istrgInfo ) ;

    srtstrngset.add ( istrgInfo ) ;

  } /* endfor */

  return  lRetVal ;

} /* long getAllDatabaseInfo ( SortedIStrings & srtstrngset ) */



long getAllDatabaseNames ( SortedIStrings & srtstrngset )
{
  int               n               ;
  KeySortedDBInfo   keysorteddbinfo ;
  long              lRetVal         ;

  lRetVal = getAllDatabases ( keysorteddbinfo ) ;

  for ( n = 1 ; n <= keysorteddbinfo.numberOfElements () ; n++ )
  {
    srtstrngset.add ( keysorteddbinfo.elementAtPosition ( n ).dbName () ) ;

  } /* endfor */

  return  lRetVal ;

} /* long getAllDatabaseNames ( SortedIStrings & srtstrngset ) */


