
//  IPrivateResource does not work under all versions of AIX, this is  our substitute.  Therefore we allow substitution of
//  our local header "creslock.hpp" under AIX. This conditional will get us by until it becomes available under AIX!
//  Note that "creslock.hpp" includes the AIX header "pthread.h".  Per the AIX programming documentation, "pthread.h"MUST
//  be the first file included, thus we must put this conditional compilation expression at the top of the file.
# ifdef _AIX
  //  Locally Defined C++ Headers
  # include <creslock.hpp>
# else
  //  IBM OCL Defined C++ Headers
  # include <ireslock.hpp>
# endif /* # ifdef _AIX */


//  IBM OCL Defined C++ Headers
# include <istring.hpp>



//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <dbaseobj.hpp>
# include <threadobj.hpp>
# include <dbconn.hpp>




DBConnection :: DBConnection ( const char * cszServer , const char * cszUser , const char * cszPassword )
    : istrgServer   ( cszServer   ) ,
      istrgUser     ( cszUser     ) ,
      istrgPassWd   ( cszPassword ) ,
      bIsConnected  ( false )
{

} /* DBConnection :: DBConnection ( const char * cszServer , const char * cszUser , const char * cszPassword ) */



DBConnection :: DBConnection ( DBConnection & rdbcon )
    : istrgServer   ( rdbcon.server       ()  ) ,
      istrgUser     ( rdbcon.user         ()  ) ,
      istrgPassWd   ( rdbcon.password     ()  ) ,
      bIsConnected  ( rdbcon.isConnected  ()  )
{

} /* DBConnection :: DBConnection ( DBConnection & rcdbcon ) */



Boolean DBConnection :: isConnected ()
{
  IResourceLock ireslock ( objectResource () ) ;

  return  bIsConnected  ;

} /* Boolean DBConnection :: isConnected () */



const char * DBConnection :: password ()
{
  IResourceLock ireslock ( objectResource () ) ;

  return  istrgPassWd ;

} /* const char * DBConnection :: password () */



const char * DBConnection :: server ()
{
  IResourceLock ireslock ( objectResource () ) ;

  return  istrgServer ;

} /* const char * DBConnection :: server () */



Boolean DBConnection :: setConnected ( Boolean bFlag )
{
  IResourceLock ireslock ( objectResource () ) ;

  return  bIsConnected  = bFlag ;

} /* Boolean DBConnection :: setConnected ( Boolean bFlag ) */



const char * DBConnection :: setPassword ( const char * cszPasswordNew )
{
  IResourceLock ireslock ( objectResource () ) ;

  return  istrgPassWd = cszPasswordNew  ;

} /* const char * DBConnection :: setPassword ( const char * cszPasswordNew ) */



const char * DBConnection :: setServer ( const char * cszServerNew )
{
  IResourceLock ireslock ( objectResource () ) ;

  return  istrgServer = cszServerNew  ;

} /* const char * DBConnection :: setServer ( const char * ) */



const char * DBConnection :: setUser ( const char * cszUserNew )
{
  IResourceLock ireslock ( objectResource () ) ;

  return  istrgUser = cszUserNew  ;

} /* const char * DBConnection :: setUser ( const char * cszUserNew ) */



const char * DBConnection :: user ()
{
  IResourceLock ireslock ( objectResource () ) ;

  return  istrgUser   ;

} /* const char * DBConnection :: user () */



