/***************************************************************************************************************************
 
    FILE NAME   :
      DBASEOBJ.CPP


    AUTHOR      :
      PETER GARNER


    DESCRIPTION :
      This module implements the interface for DatabaseObject, a super class for our Database objects.  The
      primary purpose of this class is to serialize access to a Database.

 
    METHODS DEFINED IN THIS MODULE :
      const char                * DatabaseObject :: className     () const
      static IPrivateResource   & DatabaseObject :: getDBResource ()

 
    Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.

***************************************************************************************************************************/
//  Locally Defined C++ Headers
# include <dbaseobj.hpp>






/***************************************************************************************************************************
  const char * DatabaseObject :: className () const
****************************************************************************************************************************

  RETURNS     :
    A constant pointer to the ASCIIZ string "DatabaseObject".


  DESCRIPTION :
    This VIRTUAL constant method always returns the class name of the receiver.  This may be used to implement
    a primitive Run Time Type Identification, (RTTI), or anything else you like.  Note that this IS a virtual
    function, and will early bind in the constructors and destructor.  Thus you can also use this method to
    determine in which constructor level you are, although I don't know why you would want to know that!

***************************************************************************************************************************/
const char * DatabaseObject :: className () const
{
  return  "DatabaseObject" ;

} /* const char * DatabaseObject :: className () const */



/***************************************************************************************************************************
  IPrivateResource & DatabaseObject :: getDBResource ()
****************************************************************************************************************************

  RETURNS     :
    A reference to an IPrivateResource representing our Database Connection


  DESCRIPTION :
    This static method retrieves the static IPrivateResource associated with the Database for this application.

***************************************************************************************************************************/
IPrivateResource & DatabaseObject :: getDBResource ()
{
  return  iprivresDB ;

} /* IPrivateResource & DatabaseObject :: getDBResource () */



//  Static member declaration
IPrivateResource DatabaseObject :: iprivresDB ;




/*************************************************************************************************************************** 
****************************************************  PVCS INFORMATION  ****************************************************
****************************************************************************************************************************

  $Archive: $
   
  $Author: $
   
  $Date: $

  $Description: $
   
  $Revision: $
   
  $Workfile: $
   
  $Log: $
   
****************************************************************************************************************************
****************************************************  PVCS INFORMATION  ****************************************************
***************************************************************************************************************************/



/*********************************************   END OF FILE DBASEOBJ.CPP   ***********************************************/
