/*************************************************************************************************************
 
    FILE NAME :
      DB2ERROR.CPP
 
 
    APPLICATION :
      IMPLEMENTATION OF A THROWABLE ERROR CLASS REPRESENTING AN IBM DB2 ERROR.
 
 
 
    DESCRIPTION :
      This module contains the methods used to implement the class DB2Error.  This is an IException descendant
      used to represent IBM DB2 errors.
 
 
    METHODS DEFINED IN THIS MODULE :
                    DB2Error :: DB2Error    ( const DB2Error & crdb2error )
                    DB2Error :: DB2Error    ( const char * cszMsg , unsigned long ulErrID )
                    DB2Error :: DB2Error    ( struct sqlca * psqlca )
      const char    DB2Error :: className   () const
      long          DB2Error :: init        ( struct sqlca * psqlca )
 
 
*************************************************************************************************************/
//  Locally Defined C Headers
# include <errtext.h>


//  Locally Defined C++ Headers
# include <db2error.hpp>





/**************************************************************************************************************
  TITLE       :
    DB2Error :: DB2Error ( const DB2Error & crdb2error )


  ARGUMENTS   :
    const DB2Error  & crdb2error
      A constant reference to the DB2Error object used to initialize the object being constructed.


  DESCRIPTION :
    This is the COPY constructor for an DB2Error.  This constructor creates a DEEP copy of the argument
    'crdb2error'.

**************************************************************************************************************/
DB2Error :: DB2Error ( const DB2Error & crdb2error ) : SQLException ( crdb2error )
{

} /* DB2Error :: DB2Error ( const DB2Error & crdb2error ) */



/**************************************************************************************************************
  TITLE       :
    DB2Error :: DB2Error ( const char * cszMsg , unsigned long ulErrID )


    ARGUMENTS   :
    const char          * cszMsg
      A pointer to an ASCIIZ string containing any error messages we wish to pass (may be NULL)

    unsigned long         ulErrID
      The primary error code as a long unsigned int


  DESCRIPTION :
    This constructor creates a DB2Error given the code location, the primary error code, and an error message
    as an ASCIIZ string.

**************************************************************************************************************/
DB2Error :: DB2Error ( const char * cszMsg , unsigned long ulErrID ) : SQLException ( cszMsg , ulErrID )
{

} /* DB2Error :: DB2Error ( const char * cszMsg , unsigned long ulErrID ) */



/**************************************************************************************************************
  TITLE       :
    DB2Error :: DB2Error ( struct sqlca * psqlca )


  ARGUMENTS   :
      struct sqlca        * psqlca
        A pointer to the sqlca structure that was used in the database call that encountered the error we are throwing.
        This sqlca contain will contain all of the needed information from which we will create the DB2Error Object.

  DESCRIPTION :
    This constructor creates a DB2Error given an SQL Communications Area Structure (sqlca).

**************************************************************************************************************/
DB2Error :: DB2Error ( struct sqlca * psqlca ) : SQLException ( 0 , 0 )
{
  init ( psqlca ) ;

} /* DB2Error :: DB2Error ( const CodeLocation & crcodelocation , struct sqlca * psqlca ) */



/**************************************************************************************************************
  TITLE       :
    const char * DB2Error :: className () const


  RETURNS     :
    A constant pointer to the ASCIIZ string "CodeLocation".


  DESCRIPTION :
    This VIRTUAL constant method always returns the class name of the receiver.  This may be used to implement
    a primitive Run Time Type Identification, (RTTI), or anything else you like.  Note that this IS a virtual
    function, and will early bind in the constructors and destructor.  Thus you can also use this method to
    determine in which constructor level you are, although I don't know why you would want to know that!

**************************************************************************************************************/
const char * DB2Error :: className () const
{
  return  "DB2Error" ;

} /* const char * DB2Error :: className () const */



/**************************************************************************************************************
  TITLE       :
    long DB2Error :: init ( struct sqlca * psqlca )


  ARGUMENTS   :
  struct sqlca  * psqlca
    A pointer to the sqlca structure that was used in the database call that encountered the error we are throwing.


  RETURNS
    The sqlca.sqlcode from the input argument 'struct sqlca * psqlca'


  DESCRIPTION :
    This constructor initializes a DB2Error object given an SQLCA structure.

**************************************************************************************************************/
long DB2Error :: init ( struct sqlca * psqlca )
{
  char szErrBuff   [MAX_SQL_MSG + 1]  ;

  //  Copy the SQL Error and State Messages into 'szErrBuff'
  setErrorId ( db2ErrorText ( szErrBuff , psqlca ) ) ;
  //  Append those messages to the error text in the receiver
  appendText ( szErrBuff ) ;

  return  errorId () ;

} /* long DB2Error :: init ( struct sqlca * psqlca ) */



/*************************************************   END OF FILE DB2ERROR.CPP   *******************************************/
