
//  IBM OCL Defined C++ Headers
# include <icursor.h>
# include <iksbag.h>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <keystrng.hpp>

# include <coltrans.hpp>




//  Typedefine for AN ORDERED CURSOR of datatype string pairs, e.g. {enCHAR      , "CHARACTER"}
typedef IOrderedCursor < ColumnTypePair > SQLDataTypeCursor ;




ColumnInfoTranslator :: ColumnInfoTranslator () : sqldatatranslator ( 16 )
{                            
  getTypeTranslator ().add ( ColumnTypePair ( ""            ,  enUNKNOWN  ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "CHARACTER"   ,  enCHAR     ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "VARCHAR"     ,  enVARCHAR  ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "SMALLINT"    ,  enSMALLINT ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "INTEGER"     ,  enINT      ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "DECIMAL"     ,  enFIXED    ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "DOUBLE"      ,  enFLOAT    ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "DATE"        ,  enDATE     ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "TIMESTAMP"   ,  enDATETIME ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "BLOB"        ,  enBLOB     ) ) ;
  getTypeTranslator ().add ( ColumnTypePair ( "CLOB"        ,  enCBLOB    ) ) ;

} /* ColumnInfoTranslator :: ColumnInfoTranslator () */



char ColumnInfoTranslator :: fromBool ( Boolean bNullable ) const
{
  return  bNullable ? 'Y' : 'N' ;

} /* char ColumnInfoTranslator :: fromBool ( Boolean bNullable ) const */



SQLDataType ColumnInfoTranslator :: fromString ( const char * cszDataType ) const
{
  SQLDataTypeCursor * picursor  = getTypeTranslator ().newCursor () ;

  try
  {
    forCursor ( * picursor )
    {
      if ( 0 == strcmp ( cszDataType , (const char *) picursor -> element () ) )
      {
        SQLDataType   sqldatatype = (SQLDataType) ( picursor -> element ().key () ) ;

        delete  picursor ;

        return  sqldatatype ;

      } /* endif */

    } /* forCursor ( piCursor ) */

  } /* endtry */
  catch ( IException & riexcp )
  {
    delete  picursor ;

    IRETHROW ( riexcp ) ;

  } /* endcatch ( IException & riexcp ) */

  delete  picursor ;

  return  enUNKNOWN ;

} /* SQLDataType ColumnInfoTranslator :: fromString ( const char * cszDataType ) const */



const char * ColumnInfoTranslator :: className () const
{
  return  "ColumnInfoTranslator" ;

} /* const char * ColumnInfoTranslator :: className () const */



const SQLDataTypeTranslator & ColumnInfoTranslator :: getTypeTranslator () const
{
  return  sqldatatranslator ;

} /* const SQLDataTypeTranslator & ColumnInfoTranslator :: getTypeTranslator () const */



SQLDataTypeTranslator & ColumnInfoTranslator :: getTypeTranslator ()
{
  return  sqldatatranslator ;

} /* SQLDataTypeTranslator & ColumnInfoTranslator :: getTypeTranslator () */



IBoolean ColumnInfoTranslator :: toBool ( char cNullableYN ) const
{
  return  'Y' == cNullableYN ? true : false ;

} /* IBoolean ColumnInfoTranslator :: toBool ( char cNullableYN ) const */



const char * ColumnInfoTranslator :: toString ( SQLDataType sqldatatype ) const
{
  return  getTypeTranslator ().elementWithKey ( sqldatatype ) ;

} /* const char * ColumnInfoTranslator :: toString ( SQLDataType sqldatatype ) const */


