

# include <memory.h>


# include <charcol.hpp>




const int cnGblMargin = 4 ;



CharArrayColumn :: CharArrayColumn () : DataColumn ()
{
  

} /* CharArrayColumn :: CharArrayColumn () */



CharArrayColumn :: CharArrayColumn ( const TableColumn & crtablecolumn )
{
  init ( crtablecolumn ) ;

} /* CharArrayColumn :: CharArrayColumn ( const TableColumn & crtablecolumn ) */



CharArrayColumn :: CharArrayColumn ( const CharArrayColumn & crcharraycolumn )
  : DataColumn  ( crcharraycolumn               ) ,
    charryData  ( crcharraycolumn.chararray ()  )
{

} /* CharArrayColumn :: CharArrayColumn ( const CharArrayColumn & crcharraycolumn ) */



CharArray & CharArrayColumn :: chararray ()
{ 
  return charryData ;

} /* CharArray & CharArrayColumn :: chararray () */



const CharArray & CharArrayColumn :: chararray () const
{
  return charryData ;

}



char * CharArrayColumn :: data ()
{
  return chararray ().getBase () ;

} /* char * CharArrayColumn :: data () */



const char * CharArrayColumn :: data () const
{
  return chararray ().getBase () ;

} /* const char * CharArrayColumn :: data () const */



const char * CharArrayColumn :: className () const
{
  return "CharArrayColumn" ; 

} /* const char * CharArrayColumn :: className () const */



const char * CharArrayColumn :: getVal () const
{
  return  data  ()  ; 

} /* const char * CharArrayColumn :: getVal () const */



unsigned CharArrayColumn :: init ( const TableColumn & crtablecolumn )
{
  size_t  stDataLength  = max ( crtablecolumn.displayLength () , strlen ( crtablecolumn.columnName () ) ) + cnGblMargin  ;

  chararray ().init ( stDataLength ) ;
  memset    ( data () , ' ' , chararray ().size () ) ;

  return DataColumn :: init ( crtablecolumn ) ;

} /* unsigned CharArrayColumn :: init ( const TableColumn & crtablecolumn ) */



unsigned CharArrayColumn :: init
          (
          unsigned      uColNo      ,
          const char  * cszColName  ,
          SQLDataType   sqldatatype ,
          unsigned      uColLength  ,
          unsigned      uColScale   ,
          Boolean       bNullable   ,
          unsigned      uDisplayLen
          )
{
  size_t  stDataLength  = max ( uDisplayLen , strlen ( cszColName ) ) + cnGblMargin  ;

  chararray ().init ( stDataLength ) ;
  memset    ( data () , ' ' , chararray ().size () ) ;

  return  TableColumn :: init ( uColNo , cszColName , sqldatatype , uColLength , uColScale , bNullable , uDisplayLen ) ;

} /* unsigned CharArrayColumn :: init ( unsigned , const char * , SQLDataType , unsigned , unsigned , Boolean , unsigned ) */



const char * CharArrayColumn :: setVal ( const char * cszNewVal )
{
  return  (char *) memcpy ( data () , cszNewVal , strlen ( cszNewVal ) ) ;

} /* virtual const char * CharArrayColumn :: setVal ( const char * cszNewVal ) */


