//  IBM DB2 Defined C Headers
# include <sqlcli.h>


//  IBM OCL Defined C++ Headers
# include <icursor.h>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <keystrng.hpp>
# include <coltrans.hpp>
# include <clitrans.hpp>




SQLDataType CLIColTranslator :: fromCLIType ( long lNativeType ) const
{
  switch ( lNativeType )
  {
    case  SQL_BLOB      :
      return  enBLOB      ;

    case  SQL_CHAR      :
      return  enCHAR      ;

    case  SQL_CLOB      :
      return  enCBLOB     ;

    case  SQL_DATE      :
      return  enDATE      ;

    case  SQL_DECIMAL   :
      return  enFIXED     ;

    case  SQL_DOUBLE    :
      return  enFLOAT     ;

    case  SQL_FLOAT     :
      return  enFLOAT     ;

    case  SQL_INTEGER   :
      return  enINT       ;

    case  SQL_NUMERIC   :
      return  enFLOAT     ;

    case  SQL_REAL      :
      return  enFLOAT     ;

    case  SQL_SMALLINT  :
      return  enSMALLINT  ;

    case  SQL_TIME      :
      return  enTIME      ;

    case  SQL_TIMESTAMP :
      return  enDATETIME  ;

    case  SQL_VARCHAR   :
      return  enVARCHAR   ;
      
  } /* endswitch */

  return  enUNKNOWN ;

} /* SQLDataType CLIColTranslator :: fromCLIType ( long lNativeType ) const */



const char * CLIColTranslator :: className () const
{
  return  "CLIColTranslator" ;

} /* const char * CLIColTranslator :: className () const */



long CLIColTranslator :: toCLIType ( SQLDataType sqldatatype ) const
{
  switch ( sqldatatype )
  {
    case  enBLOB      :
      return  SQL_BLOB      ;

    case  enCHAR      :
      return  SQL_CHAR      ;

    case  enCBLOB     :
      return  SQL_CLOB      ;

    case  enDATE      :
      return  SQL_DATE      ;

    case  enFIXED     :
      return  SQL_DECIMAL   ;

    case  enFLOAT     :
      return  SQL_DOUBLE    ;

    case  enINT       :
      return  SQL_INTEGER   ;

    case  enSMALLINT  :
      return  SQL_SMALLINT  ;

    case  enTIME      :
      return  SQL_TIME      ;

    case  enDATETIME  :
      return  SQL_TIMESTAMP ;

    case  enVARCHAR   :
      return  SQL_VARCHAR   ;
      
  } /* endswitch */

  return  enUNKNOWN ;

} /* long CLIColTranslator :: toCLIType ( SQLDataType sqldatatype ) const */

