/***************************************************************************************************************************
 
    FILE NAME :
      CLISTMT.CPP
 
 
    APPLICATION :
      GENERAL IMPLEMENTATION OF A CLI STATEMENT OBJECT
 

    DESCRIPTION :

 
    METHODS DEFINED IN THIS MODULE :


 
***************************************************************************************************************************/
//  System Defined C Headers
# include <stddef.h>


//  IBM DB2 Defined C Headers
# include <sqlcli1.h>

//  IBM OCL Defined C++ Headers
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <sqlstmt.hpp>
# include <cliinfo.hpp>
# include <clistmt.hpp>



CLIStatement :: CLIStatement ( SQLHDBC sqlhdbcNew , SQLHENV sqlhenvNew , const char * cszSQLText )
  : SQLStatement ( cszSQLText ) , sqlhdbc ( sqlhdbcNew ) , sqlhenv ( sqlhenvNew )
{
  SQLRETURN sqlreturn = SQLAllocStmt ( getHDBC () , & getHStmt () ) ;

  if ( SQL_SUCCESS != sqlreturn )
  {
    const char  * szMSG = "Can't Allocate Statement Handle  " ;

    THROWCLI ( getHEnv () , getHDBC () , getHStmt () , szMSG ) ;

  } /* endif */

} /* CLIStatement :: CLIStatement ( CLIConnection & rdbclic , const IString & rcistrgSQLText ) */



CLIStatement :: ~CLIStatement ()
{
  SQLFreeStmt ( getHStmt () , SQL_DROP ) ;

} /* CLIStatement :: ~CLIStatement () */



int CLIStatement :: calcNumRows ()
{
  SQLINTEGER  sqlnRows  ;

  SQLRETURN   sqlreturn = SQLRowCount ( getHStmt () , & sqlnRows ) ;

  CHECK_CLI_ERROR ( sqlreturn , 0 , 0 , getHStmt () , "Error Counting Query Rows " ) ;

  return  sqlnRows ;

} /* int CLIStatement :: calcNumCols () */



const char * CLIStatement :: className () const
{
  return  "CLIStatement" ;

} /* const char * CLIStatement :: className () const */



SQLHDBC & CLIStatement :: getHDBC ()
{
  return  sqlhdbc ;

} /* SQLHDBC & CLIStatement :: getHDBC () */



SQLHENV & CLIStatement :: getHEnv ()
{
  return  sqlhenv ;  

} /* SQLHENV & CLIStatement :: getHEnv () */


SQLHSTMT & CLIStatement :: getHStmt ()
{
  return  sqlhstmt ;

} /* SQLHSTMT & CLIStatement :: getHStmt () */



long CLIStatement :: run ()
{
  SQLSMALLINT     sqlsCols  = 0                                                     ;
  const char    * szMSG     = "Can't Execute Statement Handle  "                    ;
  SQLRETURN       sqlreturn = SQLExecDirect ( getHStmt () , (SQLCHAR *) sqlText () , SQL_NTS )  ;

  if ( SQL_NO_DATA_FOUND == sqlreturn )
  {
    return  sqlreturn ;

  } /* endif */

  CHECK_CLI_ERROR ( sqlreturn , getHEnv () , getHDBC () , getHStmt () , szMSG ) ;

  sqlreturn = SQLNumResultCols ( getHStmt () , & sqlsCols ) ;

  CHECK_CLI_ERROR ( sqlreturn , 0 , 0 , getHStmt () , "Error Counting Fetch Columns " ) ;

  setNumCols ( sqlsCols ) ;

  return  sqlreturn ;

} /* long CLIStatement :: run () */



SQLHSTMT & CLIStatement :: setHStmt ( SQLHSTMT sqlhstmtNew )
{
  return  sqlhstmt = sqlhstmtNew ;

} /* SQLHSTMT & CLIStatement :: setHStmt ( SQLHSTMT sqlhstmtNew ) */



/**************************************  END OF FILE CLISTMT.CPP               ********************************************/

