//  IBM DB2 Defined C Headers
# include <sqlcli1.h>


//  IBM OCL Defined C++ Headers
# include <idsexc.hpp>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <cliinfo.hpp>





CLIErrorStruct :: CLIErrorStruct ( SQLHENV  sqlhenvErr , SQLHDBC sqlhdbcErr , SQLHSTMT sqlhstmtErr )
{
  memset ( this , 0 , sizeof ( CLIErrorStruct ) ) ;

  sqlhenv   = sqlhenvErr  ;
  sqlhdbc   = sqlhdbcErr  ;
  sqlhstmt  = sqlhstmtErr ;

} /* CLIErrorStruct :: CLIErrorStruct ( SQLHENV  sqlhenvErr , SQLHDBC sqlhdbcErr , SQLHSTMT sqlhstmtErr ) */





CLIErrorStruct :: CLIErrorStruct ( const CLIErrorStruct & crclierrorstruct )
{
  memmove ( & sqlhenv , & crclierrorstruct , sizeof ( CLIErrorStruct ) ) ;

} /* CLIErrorStruct :: CLIErrorStruct ( SQLHENV  sqlhenvErr , SQLHDBC sqlhdbcErr , SQLHSTMT sqlhstmtErr ) */




CLIErrorInfo :: CLIErrorInfo ( SQLHENV  sqlhenvErr , SQLHDBC sqlhdbcErr , SQLHSTMT sqlhstmtErr )
  : CLIErrorStruct ( sqlhenvErr , sqlhdbcErr , sqlhstmtErr )
{
  //  Call the CLI "C" API SQLError to get the necessary information regarding database condition
  :: SQLError
      (
      sqlhenv     ,
      sqlhdbc     ,
      sqlhstmt    ,
      sqlszStat   ,
    & sqlnErr     ,
      sqlszErr    ,
      csqlsMSG_LEN,
    & sqlsErrLen
      ) ;

} /* CLIErrorInfo :: CLIErrorInfo ( SQLHENV  sqlhenvErr , SQLHDBC sqlhdbcErr , SQLHSTMT sqlhstmtErr ) */



IString CLIErrorInfo :: getFullMsg () const
{
  IString istrg = IString ( "SQLState :  " ) + IString ( sqlszStat ) + IString ( "  " ) + IString ( sqlszErr ) ;
  
  return  istrg ;

} /* IString CLIErrorInfo :: getFullMsg () const */



CLIErrorInfo :: CLIErrorInfo ( const CLIErrorInfo & crclierrorinfo ) : CLIErrorStruct ( crclierrorinfo )
{

} /* CLIErrorInfo :: CLIErrorInfo ( SQLHENV  sqlhenvErr , SQLHDBC sqlhdbcErr , SQLHSTMT sqlhstmtErr ) */



long CLIErrorInfo :: errorId () const
{
  return  sqlnErr ;

} /* long CLIErrorInfo :: errorId () const */



const char * CLIErrorInfo :: className () const
{
  return  "CLIErrorInfo" ;

} /* const char * CLIErrorInfo :: className () const */
