
//  IPrivateResource does not work under all versions of AIX, this is  our substitute.  Therefore we allow substitution of
//  our local header "creslock.hpp" under AIX. This conditional will get us by until it becomes available under AIX!
//  Note that "creslock.hpp" includes the AIX header "pthread.h".  Per the AIX programming documentation, "pthread.h"MUST
//  be the first file included, thus we must put this conditional compilation expression at the top of the file.
# ifdef _AIX
  //  Locally Defined C++ Headers
  # include <creslock.hpp>
# else
  //  IBM OCL Defined C++ Headers
  # include <ireslock.hpp>
# endif /* # ifdef _AIX */


//  System Defined C Headers
# include <stddef.h>


//  IBM DB2 Defined C Headers
# include <sqlcli1.h>


//  Locally Defined C Headers
# include <cpuport.h>
# include <os2port.h>


//  System Defined C++ Headers
# include <fstream.h>
# include <iomanip.h>


//  IBM OCL Defined C++ Headers
# include <iexcept.hpp>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <fstrmchk.hpp>
# include <dbaseobj.hpp>
# include <threadobj.hpp>
# include <dbconn.hpp>
# include <cliconn.hpp>
# include <sqlstmt.hpp>
# include <clistmt.hpp>
# include <dbinfo.hpp>
# include <cliinfo.hpp>
# include <clidb.hpp>
# include <showexp.hpp>
# include <coltrans.hpp>
# include <clitrans.hpp>
# include <charcol.hpp>



//  Dummy define so that we can stub these any of these functions by replacing the database call with a call to 'sleep'
//  This allows us to test stubs of these functions with a delay time.  This is used in multithread testing.
# define  TEST_SLEEP_TIME   5


typedef TemplateArray < CharArrayColumn > CharColumnArray ;



void printHeader ( ostream & rostrm , const CharColumnArray & rccharcolarray ) ;



CLIDatabase :: CLIDatabase ( const char * cszServer , const char * cszUser , const char * cszPassword )
  : CLIConnection ( cszServer , cszUser , cszPassword )
{

} /* CLIDatabase :: CLIDatabase ( const char * cszServer , const char * cszUser , const char * cszPassword ) */



CLIDatabase :: CLIDatabase ( CLIDatabase & rclidb )
  : CLIConnection ( rclidb )
{

} /* CLIDatabase :: CLIDatabase ( CLIDatabase & rclidb ) */



void CLIDatabase :: fileResults ( ostream & rostrm , CLIStatement & rclistmt )
{
  //  Unintialized Data
  Boolean           bNullable                             ;
  CLIColTranslator  clicoltrans                           ;
  SQLCHAR           szColName [MAX_C_IDENTIFIER + 1]      ;
  SQLDataType       sqldatatype                           ;
  SQLSMALLINT       sqlsColType                           ;
  SQLSMALLINT       sqlsColNameLen                        ;
  SQLSMALLINT       sqlsNullable                          ;
  SQLINTEGER        sqlnColLen                            ;
  SQLUINTEGER       sqluPrecision                         ;
  SQLSMALLINT       sqlsScale                             ;
  SQLRETURN         sqlret                                ;
  SQLINTEGER        sqlnDisplayLen                        ;

  //  Intialized Data
  unsigned          u             = 0                     ;
  unsigned          uCols         = rclistmt.numCols  ()  ;
  unsigned long     ulRowCount    = 0                     ;
  CharColumnArray   charcolarray  ( uCols )               ;
  SQLHSTMT          sqlhstmt      = rclistmt.getHStmt ()  ;

  while ( u < uCols )
  {
    CharArrayColumn   & rcharcol  = charcolarray [u] ;

    u++ ;

    sqlret = SQLDescribeCol
              (
              sqlhstmt              ,
              u                     ,
              szColName             ,
              sizeof ( szColName )  ,
              & sqlsColNameLen      ,
              & sqlsColType         ,
              & sqluPrecision       ,
              & sqlsScale           ,
              & sqlsNullable
              ) ;

    sqlret = SQLColAttributes ( sqlhstmt , u , SQL_COLUMN_DISPLAY_SIZE , 0 , 0 , 0 , & sqlnDisplayLen ) ;

    sqldatatype   = clicoltrans.fromCLIType ( sqlsColType ) ;
    bNullable     = SQL_NULLABLE == sqlsNullable            ;

    rcharcol.init
              (
              u                         ,
              (const char *) szColName  ,
              sqldatatype               ,
              (unsigned) sqluPrecision  ,
              (unsigned) sqlsScale      ,
              bNullable                 ,
              (unsigned) sqlnDisplayLen
              ) ;

    sqlret = SQLBindCol ( sqlhstmt , u , SQL_C_CHAR, rcharcol.data () , rcharcol.chararray ().size () , & sqlnColLen ) ;

    CHECK_CLI_ERROR ( sqlret , getHEnv () , getHDBC () , sqlhstmt , "Error on SQLBindCol" ) ;

  } /* endfor */

  printHeader ( rostrm , charcolarray ) ;

  while ( SQL_NO_DATA_FOUND != ( sqlret = SQLFetch ( sqlhstmt ) ) )
  {
    CHECK_CLI_ERROR ( sqlret , getHEnv () , getHDBC () , sqlhstmt , "Error on SQLFetch" ) ;

    ulRowCount++ ;

    for ( u = 0 ; u < uCols ; u++ )
    {
      sqlnColLen  = charcolarray [u].chararray ().numElems () ;

      rostrm << setw ( sqlnColLen ) << charcolarray [u].data () ;

    } /* endfor */

    rostrm << '\n' ;

  } /* endwhile  */

  rostrm << "\n\n" << ulRowCount << " rows returned\n\n" ;

} /* void CLIDatabase :: fileResults ( ostream & rostrm , CLIStatement & rclistmt ) */



long CLIDatabase :: getDatabaseInfos ( SortedIStrings & isrtset ) const
{
  return getAllDatabaseInfo ( isrtset ) ;

} /* long CLIDatabase :: getDatabaseInfos ( SortedIStrings & isrtset ) const */



long CLIDatabase :: getDatabaseNames ( SortedIStrings & isrtset ) const
{
  return getAllDatabaseNames ( isrtset ) ;

} /* long CLIDatabase :: getDatabaseNames ( SortedIStrings & isrtset ) const */


void CLIDatabase :: runQuery ( const char * cszSQL , const char * cszOutFile )
{
  FStreamCheck  fstrmchk  ( cszOutFile , ios :: out | ios :: trunc ) ;

  try
  {
    //  Obtain a lock for the receiving object
    IResourceLock   ireslock  ( objectResource () ) ;

    CLIStatement  clistmt   ( getHDBC () , getHEnv () , cszSQL ) ;
    long          lRetVal   = clistmt.run () ;
    int           nRows     = 0 ;

    if ( SQL_NO_DATA_FOUND == lRetVal )
    {
      fstrmchk << "SQL Statement completed successfully.\n0 rows were affected.\n" ;

      return  ;

    } /* endif */

    if ( 0 == clistmt.numCols () )  //  Assume statement was NOT a select statement
    {
      try
      {
        nRows = clistmt.calcNumRows () ;        

      } /* endtry */
      catch ( CLIError & rclierr )
      {
        //  Generally, an exception thrown from calcNumRows does not indicate a serious error, but rather
        //  that a statement like 'commit' or 'rollback' was executed.  If the statement DID not complete
        //  successfully, the exception will be thrown above when the statement is run.
        nRows = 0 ;

      } /* endcatch ( CLIError & rclierr ) */

      fstrmchk << "SQL Statement completed successfully\n" ;

      //  If statement was not a delete, insert, or update, nRows will be -1
      if ( -1 != nRows )
      {
        fstrmchk << nRows << " rows were affected.\n" << endl ; 

      } /* endif */

      return  ;

    } /* endif */

    //  If we get to this point, we have successfully executed a select statement and also have a results set,
    //  so send them to our output file
    fileResults ( fstrmchk , clistmt ) ;

  } /* endtry */
  catch ( IException & riex )
  {
    fstrmchk  << riex ;

  } /* endcatch ( IException & riex ) */

} /* void CLIDatabase :: runQuery ( const char * cszSQL , const char * cszOutFile ) */



void printHeader ( ostream & rostrm , const CharColumnArray & rccharcolarray )
{
  size_t    stColumnLength  = 0                           ;
  unsigned  uIndex          = 0                           ;
  unsigned  uColumns        = rccharcolarray.numElems ()  ;
  unsigned  uCurrColumn     = 0                           ;

  rostrm.setf ( ios :: left ) ;

  for ( uCurrColumn = 0 ; uCurrColumn < uColumns ; uCurrColumn++ )
  {
    stColumnLength  = rccharcolarray [uCurrColumn].chararray ().numElems () ;

    rostrm << setw ( stColumnLength ) << rccharcolarray [uCurrColumn].columnName () ;

  } /* endfor */

  rostrm << endl ;

  for ( uCurrColumn = 0 ; uCurrColumn < uColumns ; uCurrColumn++ )
  {
    stColumnLength  = rccharcolarray [uCurrColumn].chararray ().numElems () ;

    for ( uIndex = 0 ; uIndex < stColumnLength - 2 ; uIndex++ )
    {
      rostrm << '-' ;

    } /* endfor */

    rostrm << "  " ;

  } /* endfor */

  rostrm << '\n' << endl ;

} /* void printHeader ( ostream & rostrm , const CharColumnArray & rccharcolarray ) */
