
//  IPrivateResource does not work under all versions of AIX, this is  our substitute.  Therefore we allow substitution of
//  our local header "creslock.hpp" under AIX. This conditional will get us by until it becomes available under AIX!
//  Note that "creslock.hpp" includes the AIX header "pthread.h".  Per the AIX programming documentation, "pthread.h"MUST
//  be the first file included, thus we must put this conditional compilation expression at the top of the file.
# ifdef _AIX
  //  Locally Defined C++ Headers
  # include <creslock.hpp>
# else
  //  IBM OCL Defined C++ Headers
  # include <ireslock.hpp>
# endif /* # ifdef _AIX */


//  IBM DB2 Defined C Headers
# include <sqlcli1.h>


//  IBM OCL Defined C++ Headers
# include <iexcept.hpp>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <sqlerror.hpp>
# include <dbaseobj.hpp>
# include <threadobj.hpp>
# include <dbconn.hpp>
# include <cliconn.hpp>
# include <cliinfo.hpp>





CLIConnection :: CLIConnection ( const char * cszServer , const char * cszUser , const char * cszPassword )
  : DBConnection ( cszServer , cszUser , cszPassword ) , sqlhenv ( 0 ) , sqlhdbc ( 0 )
{
  SQLRETURN sqlreturn = SQLAllocEnv ( & sqlhenv ) ;    /* allocate an environment handle    */

  if ( SQL_SUCCESS != sqlreturn )
  {
    /*  If the HANDLE is NOT NULL, we need to free it! */
    if ( SQL_NULL_HENV != getHEnv () )
    {
      SQLFreeEnv ( getHEnv () ) ;

    } /* endif */

    CLIErrorInfo clierrorinfo ( (SQLHENV) getHEnv () ) ;

    IAccessError iacerr ( clierrorinfo.getFullMsg () , clierrorinfo.errorId () ) ;

    ITHROW ( iacerr ) ;

  } /* endif */

} /* CLIConnection :: CLIConnection ( const char * cszServerID , const char * cszUserID , const char * cszPassword ) */



CLIConnection :: CLIConnection ( CLIConnection & rdbclic )
    : DBConnection  ( rdbclic )            ,
      sqlhdbc       ( rdbclic.getHDBC () ) ,
      sqlhenv       ( rdbclic.getHEnv () )
{

} /* CLIConnection :: CLIConnection ( CLIConnection & rcdbclic ) */



CLIConnection :: ~CLIConnection ()
{
  /*  If the HANDLE is NOT NULL, we need to free it! */
  if ( SQL_NULL_HENV != getHEnv () )
  {
    disconnect    () ;
    SQLFreeEnv    ( getHEnv () ) ;

  } /* endif */
  
} /* CLIConnection :: ~CLIConnection () */



long CLIConnection :: commit ()
{
  SQLRETURN sqlreturn = SQLTransact ( getHEnv () , getHDBC () , SQL_COMMIT ) ;

  if ( SQL_SUCCESS != sqlreturn )
  {
    const char  * szMSG = "Can't Commit Current Transaction  " ;

    THROWCLI ( getHEnv () , getHDBC () , 0 , szMSG ) ;

  } /* endif */

  return  sqlreturn ;

} /* long CLIConnection :: commit () */



long CLIConnection :: connect ()
{
  SQLRETURN       sqlreturn ;

  // Disconnect gets a resource lock as well
  disconnect () ;

  //  Obtain a lock for the receiving object
  IResourceLock   ireslock  ( objectResource () ) ;

  /* allocate a connection handle     */
  sqlreturn = SQLAllocConnect ( getHEnv () , & sqlhdbc ) ;

  if ( SQL_SUCCESS != sqlreturn )
  {
    CLIErrorInfo   clierrorinfo ( (SQLHENV) getHEnv () ) ;    

    IAccessError iacerr 
                      (
                      "Cannot Allocate CLI Connection " + clierrorinfo.getFullMsg () ,
                      clierrorinfo.errorId ()
                      ) ;

    ITHROW ( iacerr ) ;

  } /* endif */


# ifdef __AUTOCOMMIT_OFF
  /* Set AUTOCOMMIT OFF */
  sqlreturn = SQLSetConnectOption ( getHDBC () , SQL_AUTOCOMMIT , SQL_AUTOCOMMIT_OFF ) ;

  if ( SQL_SUCCESS != sqlreturn )
  {
    THROWCLI ( getHEnv () , getHDBC () , 0 , "Can't Set AutoCommit Option Off  " ) ;

  } /* endif */
# endif  /* # ifdef __AUTOCOMMIT_OFF */

  sqlreturn = SQLConnect
                (
                getHDBC ()              ,
                (SQLCHAR *) server ()   ,
                SQL_NTS                 ,
                (SQLCHAR *) user ()     ,
                SQL_NTS                 ,
                (SQLCHAR *) password () ,
                SQL_NTS 
                ) ;

  if ( SQL_SUCCESS != sqlreturn )
  {
    SQLDisconnect  ( getHDBC () ) ;
    SQLFreeConnect ( getHDBC () ) ;
    
    CLIErrorInfo   clierrorinfo ( (SQLHENV) getHEnv () , getHDBC () ) ;
    IString istrgMsg = IString ( "Cannot Connect CLI Connection " ) + server () ;
    istrgMsg += "  " ;

    IAccessError iacerr ( istrgMsg + clierrorinfo.getFullMsg () , clierrorinfo.errorId () ) ;

    ITHROW ( iacerr ) ;

  } /* endif */

  setConnected  ()  ;

  return  sqlreturn ;  

} /* long CLIConnection :: connect () */




long CLIConnection :: disconnect ()
{
  SQLRETURN       sqlreturn = 0 ;

  //  Obtain a lock for the receiving object
  IResourceLock   ireslock  ( objectResource () ) ;

  if ( isConnected () && getHDBC () )
  {
    sqlreturn = SQLDisconnect  ( getHDBC () ) ;
    sqlreturn = SQLFreeConnect ( getHDBC () ) ;

  } /* endif */

  setConnected  ( false ) ;

  return  sqlreturn ;

} /* long CLIConnection :: disconnect () */



const char * CLIConnection :: className () const
{
  return  "CLIConnection" ;

} /* const char * CLIConnection :: className () const */



SQLHDBC CLIConnection :: getHDBC () const
{
  return  sqlhdbc ;

} /* SQLHDBC CLIConnection :: getHDBC () const */



SQLHENV CLIConnection :: getHEnv () const
{
  return  sqlhenv ;

} /* SQLHENV CLIConnection :: getHEnv () const */



long CLIConnection :: rollback ()
{
  SQLRETURN sqlreturn = SQLTransact ( getHEnv () , getHDBC () , SQL_ROLLBACK ) ;

  if ( SQL_SUCCESS != sqlreturn )
  {
      const char  * szMSG = "Can't RollBack Current Transaction  " ;

      THROWCLI ( getHEnv () , getHDBC () , 0 , szMSG ) ;

  } /* endif */

  return  sqlreturn ;

} /* long CLIConnection :: rollback () */





/*******************************************  END OF FILE CLICONN.CPP     *************************************************/

