#===========================================================================
#
#   Sample common definitions for the IBM CSet++ compiler environment.
#   These are meant for use with our OWN code.
#
#   The following compiler flags are used by our code :
#
#     /Fi-      Do NOT Generate Precompiled Header Files
#     /G5       Produce Object Code Optimised for the 80586
#     /Gd-      DO NOT use DLLs for the libraries
#     /Gm+      Compile MULTITHREADED target, link with MULTITHREAD Libraries
#     /J-       Make Default Char Type Signed.
#     /O-       Disable ALL optimizations
#     /Q+       Suppress the IBM Logo
#     /Si-      Do NOT Use Precompiled Header Files
#     /W3       Output ALL Messages Generated by the Compiler.
#     /Xi+      Do NOT search environment variable INCLUDE path for includes
#
#
#===========================================================================


# LIB DIRECTORIES AND FILE PATHS
HOME          = D:\DRT\PRG\COMMON
COMMON        = $(HOME)
IBMHOME       = D:\IBMCPP
SQLHOME       = C:\SQLLIB
TKTHOME       = $(IBMHOME)\INCLUDE
TCPHOME       = C:\TCPIP
SQLSRCE       = $(COMMON)\SQL


COMINC        = .;$(COMMON)\INCLUDE;
SQLINC        = $(SQLHOME)\INCLUDE;
STDINC        = $(IBMHOME)\INCLUDE;$(IBMHOME)\INCLUDE\SYS;
STLINC        = D:\APP\STLINC
TCPINC        = $(TCPHOME)\INCLUDE;$(TCPHOME)\INCLUDE\SYS;
TKTINC        = $(TKTHOME)\OS2;

INCPATH       = $(STDINC);$(TKTINC);$(COMINC);$(SQLINC);$(USERINC)

DBUTIL        = $(IBOLDHOME)\DBUTIL
IBMBIN        = $(IBMHOME)\BIN
LIBDIR1       = $(COMMON)
LIBDIR2       = $(TCPHOME)\LIB
OUTLIB        = $(COMMON)


OUTBIN          = OBJ
OUTBND          = BND
OUTLIB          = LIB


COMMON_NAME   = COMMON
DB2CLI_NAME   = CLICAL
DBCALL_NAME   = DBCALL
DBSTAT_NAME   = DBSTAT
OCLDEP_NAME   = OCLDEP
OSDEPD_NAME   = OSDEPD
PRSMGR_NAME   = PRSMGR


COMMON_FNS    = $(COMMON)\$(OUTLIB)\$(COMMON_NAME)
DB2CLI_FNS    = $(COMMON)\$(OUTLIB)\$(DB2CLI_NAME)
DBCALL_FNS    = $(COMMON)\$(OUTLIB)\$(DBCALL_NAME)
DBSTAT_FNS    = $(COMMON)\$(OUTLIB)\$(DBSTAT_NAME)
OCLDEP_FNS    = $(COMMON)\$(OUTLIB)\$(OCLDEP_NAME)
OSDEPD_FNS    = $(COMMON)\$(OUTLIB)\$(OSDEPD_NAME)
PRSMGR_FNS    = $(COMMON)\$(OUTLIB)\$(PRSMGR_NAME)


COMMON_LIB    = $(COMMON_FNS).LIB
DB2CLI_LIB    = $(DB2CLI_FNS).LIB
DBCALL_LIB    = $(DBCALL_FNS).LIB
DBSTAT_LIB    = $(DBSTAT_FNS).LIB
OCLDEP_LIB    = $(OCLDEP_FNS).LIB
OSDEPD_LIB    = $(OSDEPD_FNS).LIB
PRSMGR_LIB    = $(PRSMGR_FNS).LIB
HOME_LIBS     = $(COMMON_LIB) $(COMMON)\SQL\DB2LIB.LIB
CLI_LIB       = $(SQLHOME)\LIB\DB2CLI.LIB
SQL_LIB       = $(SQLHOME)\LIB\SQL_DYN.LIB
TCP_LIBS      = $(TCPHOME)\LIB\SO32DLL.LIB $(TCPHOME)\LIB\TCP32DLL.LIB

LIBS          = $(HOME_LIBS) $(SQL_LIB)


PMCOMPDEF     = $(COMMON)\PMCOMP.DEF
WINCOMPDEF    = $(COMMON)\WINCOMP.DEF


# Default compilation switches
#
# Compile switchs  that are enabled
# /c      Compile Only.
# /Fi-    Do Not Generate precompiled header files.
# /G4     Generate code to optimize its use on an 80486
# /Gd+/-  DO/DO NOT Use dynamic libraries.
# /Gm+    Use multi-threaded libraries
# /J-     Make default char type signed.
# /O-     Disable all optimizations.
# /Q+     Suppress the logo.
# /Si-    Do not use precompiled header files
# /Tdp    Compile all the following source files as C++ files and
#         invoke link step to resolve all template functions.
# /Ti     Generate debugging information.
# /W3     Output all messages generated by the compiler.
# /Xi+    Do not search environment variable INCLUDE path.


DLLFLAG       = /Ge-
COMPFLAGS     = /Fi- /G4 /Gd- /Gm+ /J- /O- /Q+ /Si- /W3 /Xi+
DEFINES       = /D__DEBUG_MSG__
COMNFLAGS     = $(COMPFLAGS) -I$(INCPATH) $(DEFINES)
CCFLAGS       = /SS+ $(COMNFLAGS)
CCPPFLAGS     = /Tdp $(COMNFLAGS)
CCM           = $(IBMBIN)\ICC.EXE
CCND          = $(CCM) $(CCFLAGS)
CPND          = $(CCM) $(CCPPFLAGS)
CCC           = $(CCND) /Ti
CCP           = $(CPND) /Ti





BASELINK      = /M:FULL /NOE /NOI /NOP
LFLAGS        = /DEBUG $(BASELINK)
NODEB_LFLAGS  = $(BASELINK)
HLPCOMP       = $(IBMBIN)\IPFC.EXE
LD            = LINK386.EXE
LIBRARIAN     = $(IBMBIN)\LIBV2R1.EXE
LIBMAK        = $(LIBRARIAN)
LNK           = $(LD)
RESCOMP       = $(IBMBIN)\RC.EXE


SAMPDATABASE  = SAMPLE




.CC.OBJ:
  $(CCP) /C $<

.CPP.OBJ:
  $(CCP) /C $<

.CXX.OBJ:
  $(CCP) /C $<

.C.OBJ:
  $(CCC) /C $<

.RC.RES:
  $(RESCOMP) -r $<  

.I.HLP:
  $(HLPCOMP) IPFC $<

.IPF.I:
  $(CCM) /FT+ /SS /DIPF /P $<



