/***************************************************************************************************************************
   
  FILE NAME :
    NAMEDOBJ.CPP
   
   
  APPLICATION :
    GENERAL SUPERCLASS FOR ALL C++ CLASSES.
   


  DESCRIPTION :
    This module contains the definitions for the implementation of the class NamedObject.  This class is a superclass
    intended to be used as the parent of all C++ classes in a particular project.  This class sort of corresponds to the
    Smalltalk class 'Object'.  PERHAPS MOST IMPORTANTLY THIS CLASS DEFINES A DO NOTHING VIRTUAL DESTRUCTOR.  THIS ASSURES
    THAT THE DESTRUCTORS OF ALL DESCENDANT CLASSES WILL BE VIRTUAL AS WELL!

 
  METHODS DEFINED IN THIS MODULE :
    NamedObject :: ~NamedObject ()

    virtual const char  * NamedObject :: className  ()  const
    size_t                NamedObject :: nameLength ()  const
    int                   NamedObject :: isMyType   ( const NamedObject  & crnamedobject ) const
 

***************************************************************************************************************************/
//  System Defined C Headers
# include <string.h>
# include <time.h>


//  Locally Defined C++ Headers
# include "namedobj.hpp"



/***************************************************************************************************************************

  TITLE         :
    NamedObject :: ~NamedObject ()


  DESCRIPTION   :
    This is a do nothing destructor.

***************************************************************************************************************************/
NamedObject :: ~NamedObject ()
{
  //  This is a do nothing destructor, it is just a place holder so that NamedObject has a virtual destructor,
  //  thus forcing all of its' decendants to have a virtual destructor.

} /* NamedObject :: ~NamedObject () */



/***************************************************************************************************************************
    const char * NamedObject :: className () const
****************************************************************************************************************************

  RETURNS     :
    A constant pointer to the ASCIIZ string "NamedObject".


  DESCRIPTION :
    This VIRTUAL constant method always returns the class name of the receiver.  This may be used to implement
    a primitive Run Time Type Identification, (RTTI), or anything else you like.  Note that this IS a virtual
    function, and will early bind in the constructors and destructor.  Thus you can also use this method to
    determine in which constructor level you are, although I don't know why you would want to know that!

***************************************************************************************************************************/
const char * NamedObject :: className () const
{
  return  "NamedObject" ;

} /* const char * NamedObject :: className () const */



/***************************************************************************************************************************
 
  TITLE         :
    int NamedObject :: isMyType ( const NamedObject & crnamedobject ) const
 
 
  ARGUMENTS     :
    const NamedObject & crnamedobject
      A reference to a constant NamedObject or descendant thereof.
 
 
  RETURNS       :
    1 if the receiver and the argument return the same string from their className () methods
    0 otherwise
 
 
  DESCRIPTION   :
    This method compares the strings returned by NamedObject::className () to determine if the receiver and the
    input argument 'crnamedobject' are of the same type!
 
***************************************************************************************************************************/
int NamedObject :: isMyType ( const NamedObject & crnamedobject ) const
{
  //  Store the length of the receivers' class name in a local variable for quick access
  size_t  stMyNameLen = nameLength () ;

  //  If the length of the two class names are not the same, then obviously the class names are not the same
  if ( crnamedobject.nameLength () != stMyNameLen )
  {
    return  0 ;

  } /* endif */

  //  Check to see if the two class names are the same.
  //  Again we use the previously stored length so that we can memcmp which is faster than strcmp!
  if ( 0 != memcmp ( className () , crnamedobject.className () , stMyNameLen ) )
  {
    return  0 ;

  } /* endif */

  return  1 ;

} /* int NamedObject :: isMyType ( const NamedObject & crnamedobject ) const */



/***************************************************************************************************************************
  size_t NamedObject :: nameLength () const
****************************************************************************************************************************

  DESCRIPTION   :
    This method returns the length of the string returned by the receivers className () method.

***************************************************************************************************************************/
size_t NamedObject :: nameLength () const
{
  return  strlen ( className () ) ;

} /* size_t NamedObject :: nameLength () const */



/**************************************     END OF FILE NAMEDOBJ.CPP           ********************************************/
