/***************************************************************************************************************************
 
    FILE NAME :
      CURRTIME.HPP
 
 
    DESCRIPTION :
      This header contains the declarations for the class CurrentTime.  This class simply returns the current time as a long 
      or a string via calls to the C Library functions ::time and ::ctime.  In essence this class is simply a wrapper for\
      those C Library functions.
 
 
    Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.
 
***************************************************************************************************************************/
//  System Defined C Headers
# include <time.h>


//  System Defined C++ Headers
# include <iostream.h>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <currtime.hpp>




/***************************************************************************************************************************
  CurrentTime :: CurrentTime ()
****************************************************************************************************************************

  DESCRIPTION :
    This is the default constructor a CurrentTime Object.

***************************************************************************************************************************/
CurrentTime :: CurrentTime ()
{
  init () ;

} /* CurrentTime :: CurrentTime () */



/***************************************************************************************************************************
    long CurrentTime :: charTime ( char * szTime )
****************************************************************************************************************************

  ARGUMENTS   :
    char  * szTime
      A pointer to a string that will contain the system calender time when this method completes.  The format of the string
      returned is equivalent to that of the C Library function 'ctime ( char * )'


  RETURNS     :
    The system time as a long.  This is the same value returned by the C Library function '::time ( time * )'


  DESCRIPTION :
    This method returns the current system calendar time as a long.  If the argument 'szTime' is not 0, the system calender
    time will also be converted into a string via a call to the C Library function 'ctime ( char * )' and this value will be
    copied into 'szTime'.

***************************************************************************************************************************/
long CurrentTime :: charTime ( char * szTime )
{
  //  Initialize the receiver with the current system calender time
  init () ;

  if ( szTime )
  {
    strcpy ( szTime , szCurrentTime ) ;

  } /* endif */

  return  (long) ttCurrent ;

} /* long CurrentTime :: charTime ( char * szTime ) */



/***************************************************************************************************************************
    const char * CurrentTime :: className () const
****************************************************************************************************************************

  RETURNS     :
    A constant pointer to the ASCIIZ string "CurrentTime".


  DESCRIPTION :
    This VIRTUAL constant method always returns the class name of the receiver.  This may be used to implement
    a primitive Run Time Type Identification, (RTTI), or anything else you like.  Note that this IS a virtual
    function, and will early bind in the constructors and destructor.  Thus you can also use this method to
    determine in which constructor level you are, although I don't know why you would want to know that!

***************************************************************************************************************************/
const char * CurrentTime :: className () const
{
  return  "CurrentTime" ;

} /* const char * CurrentTime :: className () const */



/***************************************************************************************************************************
    long CurrentTime :: init ()
****************************************************************************************************************************

  RETURNS     :
    The system time as a long.  This is the same value returned by the C Library function '::time ( time * )'


  DESCRIPTION :
    This method initializes the contents of the receiver to the current time and returns the current system time as a long.
    This is equivalent to the C Library function '::time ( time * )'

***************************************************************************************************************************/
long CurrentTime :: init ()
{
  :: time ( & ttCurrent ) ;

  strcpy ( szCurrentTime , ctime ( & ttCurrent ) ) ;

  return  (long) ttCurrent ;

} /* long CurrentTime :: init () */



/***************************************************************************************************************************
    ostream & operator << ( ostream & rostream , CurrentTime & rcurrtime )
****************************************************************************************************************************

  ARGUMENTS   :
    ostream       & rostream
      A reference to the ostream object that is to be the destination for the contents of 'rcurrtime'

    CurrentTime   & rcurrtime
      

  RETURNS     :
    This method returns the value of the input argument 'ostream & rostream'.


  DESCRIPTION :
    This intializes the argument 'rcurrtime' to the current time and puts the string value obtained onto the ostream &
    'rostream'.

***************************************************************************************************************************/
ostream & operator << ( ostream & rostream , CurrentTime & rcurrtime )
{
  char    szCurrentTime [stTIME_LEN + 1]  ;

  rcurrtime.charTime ( szCurrentTime ) ;

  rostream  << szCurrentTime ;

  return  rostream ;

} /* ostream & operator << ( ostream & rostream , const CurrentTime & rccurrtime ) */



/**************************************     END OF FILE CURRTIME.CPP           *********************************************/
