/***************************************************************************************************************************
 
    FILE NAME :
      AUTOOBJ.CPP
 
 
    DESCRIPTION :
      This module contains the methods used to implement the class AutoObject.  This class reads an entire file into memory
      and then closes the file.  Its' purpose is to provide the ability to treat a file as a memory buffer.  Thus this class
      is a little bit like a UNIX memory mapped file.  However, unlike a UNIX memory mapped file, once the physical disk
      file has been read into memory, it is closed, unlocked and is available to other processes.
 
 
    METHODS DEFINED IN THIS MODULE :
      AutoObject :: AutoObject ( Boolean bAutoDestroy )
      AutoObject :: AutoObject ( const AutoObject & rcautobj )

      const char        * AutoObject :: className     () const 
      void                AutoObject :: destroy       ()
      Boolean             AutoObject :: shouldDestroy ( Boolean bAutoDestroy )
      Boolean             AutoObject :: willDestroy   () const
 
 
    Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.


***************************************************************************************************************************/
//  Locally Defined C++ Headers
# include <autoobj.hpp>



/***************************************************************************************************************************
  AutoObject :: AutoObject ( Boolean bAutoDestroy = true )
****************************************************************************************************************************

  ARGUMENTS   :
    Boolean bAutoDestroy = true
      This flag should be true if we want the object being constructed to delete its' contents' when it goes out of scope
      and false otherwise.

  
  DESCRIPTION :
    This method constructs a AutoObject and sets its' internal destroy flag to the value of the argument 'bAutoDestroy'.


***************************************************************************************************************************/
AutoObject :: AutoObject ( Boolean bAutoDestroy )
  : bDestroy ( bAutoDestroy )
{ 

} /* AutoObject :: AutoObject ( Boolean bAutoDestroy ) */



/***************************************************************************************************************************
  AutoObject :: AutoObject ( const AutoObject & rcautobj )
****************************************************************************************************************************

  ARGUMENTS   :
    const AutoObject  & rcautobj
      A reference to a constant AutoObject that will be the source for this DEEP copy constructor.

  
  DESCRIPTION :
    This method is the AutoObject copy constructor.  It constructs an AutoObject that is a DEEP copy of its' argument
    rcautobj.


***************************************************************************************************************************/
AutoObject :: AutoObject ( const AutoObject & rcautobj )
  : bDestroy ( rcautobj.willDestroy () )
{ 

} /* AutoObject :: AutoObject ( Boolean bAutoDestroy ) */



/***************************************************************************************************************************
  const char * AutoObject :: className () const
****************************************************************************************************************************

  RETURNS     :
    A constant pointer to the ASCIIZ string "AutoObject".


  DESCRIPTION :
    This VIRTUAL constant method always returns the class name of the receiver.  This may be used to implement
    a primitive Run Time Type Identification, (RTTI), or anything else you like.  Note that this IS a virtual
    function, and will early bind in the constructors and destructor.  Thus you can also use this method to
    determine in which constructor level you are, although I don't know why you would want to know that!

***************************************************************************************************************************/
const char * AutoObject :: className () const
{
  return  "AutoObject" ;

} /* const char * AutoObject :: className () const */



/***************************************************************************************************************************
  void AutoObject :: destroy ()
****************************************************************************************************************************

  DESCRIPTION :
    This VIRTUAL method deletes the receivers' internal memory by calling the receivers' 'deleteMem ()' method.  The latter
    method is a pure virtual method in the class AutoObject and must be defined in the child class.  This method checks the
    return value of the 'AutoObject :: willDestroy ()' to determine if the memory SHOULD be deleted.  If that method returns
    true, the memory is deleted by 'deleteMem ()'.

***************************************************************************************************************************/
void AutoObject :: destroy ()
{
  // Check to be sure that we should destroy the receivers' memory
  if ( willDestroy () )
  {
    deleteMem () ;

  } /* endif */

} /* void AutoObject :: destroy () */



/***************************************************************************************************************************
  Boolean AutoObject :: shouldDestroy ( Boolean bAutoDestroy = true )
****************************************************************************************************************************

  ARGUMENTS   :
    Boolean bAutoDestroy
      This flag should be true if we want the receiver to delete its' contents' when it goes out of scope and false
      otherwise.


  RETURNS     :
    The value of the argument 'bAutoDestroy'.

  
  DESCRIPTION :
    This method is the accessor that sets the value of the receivers' internal destroy flag to the value of the argument
    'bAutoDestroy'.


***************************************************************************************************************************/
Boolean AutoObject :: shouldDestroy ( Boolean bAutoDestroy )
{
  return  bDestroy = bAutoDestroy ;

} /* Boolean AutoObject :: shouldDestroy ( Boolean bAutoDestroy ) */



/***************************************************************************************************************************
  Boolean AutoObject :: willDestroy () const
****************************************************************************************************************************

  RETURNS     :
    The value of the receivers' internal destroy flag.

  
  DESCRIPTION :
    This method is the accessor that gets the value of the receivers' internal destroy flag.  The value of this flag
    determines whether the contents of the receiver should be deleted when it goes out of scope.


***************************************************************************************************************************/
Boolean AutoObject :: willDestroy () const
{
  return  bDestroy ;

} /* Boolean AutoObject :: willDestroy () const */


/**************************************     END OF FILE AUTOOBJ.CPP           *********************************************/
