/***************************************************************************************************************************
 
    FILE NAME :
      SORTSTRN.CPP


    APPLICATION :
      IMPLEMENTATION OF THE SORTEDISTRINGS CLASS


    DESCRIPTION :
      This module contains the implementation of the SortedIStrings class.  This class is descendant of :

        typedef ISortedSet <IString> SortedIStringSet

      The purpose of this class is to provide an easily manipulated sorted set of IStrings.

 
    METHODS DEFINED IN THIS MODULE :
      SortedIStrings :: SortedIStrings ()
      SortedIStrings :: SortedIStrings ( const char * cszInit )
      SortedIStrings :: SortedIStrings ( const SortedIStrings & rcsortistrgs )

      const char  * SortedIStrings :: className () const


    Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.


***************************************************************************************************************************/

//  Locally Defined C++ Headers
# include <sortstrn.hpp>





/***************************************************************************************************************************
  SortedIStrings :: SortedIStrings ()
****************************************************************************************************************************
  
  DESCRIPTION :
    Constructs an empty SortedIStrings object (one with no elements).

***************************************************************************************************************************/
SortedIStrings :: SortedIStrings () : SortedIStringSet ()
{

} /* SortedIStrings :: SortedIStrings () */



/***************************************************************************************************************************
  SortedIStrings :: SortedIStrings ( const char * cszInit )
****************************************************************************************************************************

  ARGUMENTS   :
    const char  * cszInit
      A pointer to a constant ASCIIZ string.  The IString constructed from this string will be added to the object being
      constructed and thus be its' sole element when this constructor finishes.


  DESCRIPTION :
    This constructor constructs a SortedIStrings object and adds the single element IString ( cszInit ) to it

***************************************************************************************************************************/
SortedIStrings :: SortedIStrings ( const char * cszInit ) : SortedIStringSet ()
{
  add ( cszInit ) ; 

} /* SortedIStrings :: SortedIStrings ( const char * cszInit ) */



/***************************************************************************************************************************
  SortedIStrings :: SortedIStrings ( const SortedIStrings & rcsortistrgs )
****************************************************************************************************************************

  ARGUMENTS   :
    const SortedIStrings & rcsortistrgs
      A reference to a constant SortedIStrings object that is to be the source for this DEEP copy constructor.


  DESCRIPTION :
    This constructor creates a SortedIStrings object as a DEEP copy of its' input argument 'rcsortedistrgs'.

***************************************************************************************************************************/
SortedIStrings :: SortedIStrings ( const SortedIStrings & rcsortistrgs ) : SortedIStringSet ( rcsortistrgs )
{

} /* SortedIStrings :: SortedIStrings ( const SortedIStrings & rcsortistrgs ) */



/***************************************************************************************************************************
    const char * SortedIStrings :: className () const
****************************************************************************************************************************

  RETURNS     :
    A constant pointer to the ASCIIZ string "SortedIStrings".


  DESCRIPTION :
    This VIRTUAL constant method always returns the class name of the receiver.  This may be used to implement
    a primitive Run Time Type Identification, (RTTI), or anything else you like.  Note that this IS a virtual
    function, and will early bind in the constructors and destructor.  Thus you can also use this method to
    determine in which constructor level you are, although I don't know why you would want to know that!

***************************************************************************************************************************/
const char * SortedIStrings :: className () const
{
  return "SortedIStrings" ;

} /* const char * SortedIStrings :: className () const */




/**************************************     END OF FILE SORTSTRN.CPP          *********************************************/

