/***************************************************************************************************************************
 
  FILE NAME :
    SHOWEXP.CPP


  APPLICATION :
    GENERAL - DECLARATION OF SOME UTILITY OPERATORS THAT OVERLOAD OSTREAM OUTPUT OF IEXCEPTIONS AND IEXCEPTIONLOCATIONS


  DESCRIPTION :
    This module contains the overloaded implementations of the  '<<'  operator onto ostream and IString for the IBM OCL 
    classes IExceptions and IExceptionLocation.
    

  UTILITY OPERATORS DEFINED IN THIS MODULE :
    IString   & operator  <<  ( IString & ristr   , const IException          & rciexp    )
    IString   & operator  <<  ( IString & ristr   , const IExceptionLocation  & rciexploc )
    ostream   & operator  <<  ( ostream & rostrm  , const IException          & rciexp    )
    ostream   & operator  <<  ( ostream & rostrm  , const IExceptionLocation  & rciexploc )


  Copyright 1997, Peter Garner
  This code may be used for any NON-MILITARY purpose.


***************************************************************************************************************************/

//  IBM OCL Defined C++ Headers
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <showexp.hpp>




/***************************************************************************************************************************
  IString & operator << ( IString & ristrg , const IException & rciexp )
****************************************************************************************************************************

  ARGUMENTS   :
    IString           & ristrg
      A reference to the IString that is to contain the exception information when this operator completes

    const IException  & rciexp
      A reference to a constant IException object that whose contents we wish to place into an IString

    
  RETURNS     :
    A reference to IString input argument 'ristrg'.

    
  DESCRIPTION :
    This operator converts all of the information, including the location information, stored in an IException object, into
    a standard text format, and copies that text into the IString input argument 'ristrg'.


***************************************************************************************************************************/
IString & operator << ( IString & ristrg , const IException & rciexp )
{
  unsigned long   ul  ;

  // Note we convert the error id from an unsigned long to a long since many error codes are negative!
  long                        lErrorID  = (long) rciexp.errorId ()  ;
  unsigned long               ulCount   = rciexp.textCount      ()  ;

  ristrg  = IString ( "Exception Type : " ) + rciexp.name ()
          + IString ( ", Error ID = "     ) + IString     ( lErrorID ) ; 
  
  //  Output ALL of the exception text messages
  for ( ul = 0 ; ul < ulCount ; ul++ )
  {
    ristrg += IString ( " " ) + rciexp.text ( ul )  ;

  } /* endfor */

  ulCount = rciexp.locationCount () ;

  if ( ulCount )
  {
    //  Only add this String if there IS Location Information
    ristrg += " Exception was thrown from these locations :\n";    

    //  Output ALL of the exception location information
    for ( ul = 0 ; ul < ulCount ; ul++ )
    {
      const IExceptionLocation  & rciexcploc = * rciexp.locationAtIndex ( ul ) ;

      ristrg <<  rciexcploc ;

    } /* endfor */

  } /* endif */

  return  ristrg ;

} /* IString & operator << ( IString & ristrg , const IException & rciexp ) */



/***************************************************************************************************************************
  IString & operator << ( IString & ristrg , const IExceptionLocation & rciexploc )
****************************************************************************************************************************

  ARGUMENTS   :
    IString           & ristrg
      A reference to the IString that is to contain the exception location information when this operator completes

    const IExceptionLocation  & rciexploc
      A reference to a constant IExceptionLocation object that whose contents we wish to place into an IString

    
  RETURNS     :
    A reference to IString input argument 'ristrg'.

    
  DESCRIPTION :
    This operator converts all of the location information, stored in an IExceptionLocation object, into a standard text
    format, and copies that text into the IString input argument 'ristrg'.


***************************************************************************************************************************/
IString & operator << ( IString & ristrg , const IExceptionLocation & rciexploc )
{
  ristrg  += IString ( "\nMethod :\n"   ) + IString ( rciexploc.functionName  () )
          +  IString ( "\nIn File :\n"  ) + IString ( rciexploc.fileName      () )
          +  IString ( "\nline # "      ) + IString ( rciexploc.lineNumber    () ) + IString ( '\n' ) ;

  return  ristrg ;

} /* IString & operator << ( IString & ristrg , const IExceptionLocation & rciexploc ) */



/***************************************************************************************************************************
  ostream & operator << ( ostream & rostrm , const IException & rciexp )
****************************************************************************************************************************

  ARGUMENTS   :
    ostream           & rostrm
      A reference to the ostream that is to be the destination for the exception information when this operator completes.

    const IException  & rciexp
      A reference to a constant IException object that whose contents we wish to print onto an ostream.

    
  RETURNS     :
    A reference to ostream input argument 'rostrm'.

    
  DESCRIPTION :
    This operator converts all of the information, including the location information, stored in an IException object, into
    a standard text format, and copies that text onto the ostream input argument 'rostrm'.


***************************************************************************************************************************/
ostream & operator << ( ostream & rostrm , const IException & rciexp )
{
  IString   istrgError  ;

  istrgError << rciexp  ;

  return  rostrm << istrgError  ;

} /* ostream & operator << ( ostream & rostrm , const IException & rciexp ) */



/***************************************************************************************************************************
  ostream & operator << ( ostream & rostrm , const IExceptionLocation & rciexploc )
****************************************************************************************************************************

  ARGUMENTS   :
    ostream           & rostrm
      A reference to the ostream that is to be the destination for the exception location information when this operator
      completes.

    const IExceptionLocation  & rciexploc
      A reference to a constant IExceptionLocation object that whose contents we wish to print onto an ostream

    
  RETURNS     :
    A reference to ostream input argument 'rostrm'.

    
  DESCRIPTION :
    This operator converts all of the location information, stored in an IExceptionLocation object, into a standard text
    format, and prints that text onto the ostream input argument 'rostrm'.


***************************************************************************************************************************/
ostream & operator << ( ostream & rostrm , const IExceptionLocation & rciexploc )
{
  IString   istrgLocInfo  ;

  istrgLocInfo  <<  rciexploc ;

  return  rostrm  <<  istrgLocInfo ;

} /* ostream & operator << ( ostream & rostrm , const IExceptionLocation & rciexploc ) */



/**************************************     END OF FILE SHOWEXP.CPP           *********************************************/
