/***************************************************************************************************************************
 
  FILE NAME :
    KEYSTRNG.CPP


  APPLICATION :
    GENERAL - DECLARATION OF AN ISTRING DESCENDANT THAT CONTAINS A SHORT KEY VALUE TO EASE INSTANTIATON OF A KEY SORTED
    SET TEMPLATE


  DESCRIPTION :
    This module contains the definitions for the class KeyedString.  This class is an IString descendant that contains
    a short integer key value.  This class is used to instantiate the template IKeySortedSet < KeyedString , short >.
    

  METHODS DEFINED IN THIS MODULE :
    KeyedString :: KeyedString ()
    KeyedString :: KeyedString ( const char * cszInit , short sNewKey )
    KeyedString :: KeyedString ( const KeyedString & crkeydstr )

    const char    * KeyedString :: className  () const
    short           KeyedString :: init       ( const KeyedString & crkeydstr )
    short const   & KeyedString :: key        () const
    short           KeyedString :: setKey     ( short sKeyNew )


  UTILITY METHODS DEFINED IN THIS MODULE :
    short const & key ( KeyedString const & crkeystring )


  Copyright 1997, Peter Garner
  This code may be used for any NON-MILITARY purpose.


***************************************************************************************************************************/

//  Locally Defined C++ Headers
# include <keystrng.hpp>





/***************************************************************************************************************************
  KeyedString :: KeyedString ()
****************************************************************************************************************************
  
  DESCRIPTION :
    Constructs an empty KeyedString object with a key value of 0.

***************************************************************************************************************************/
KeyedString :: KeyedString () : sKey ( 0 )
{

} /* KeyedString :: KeyedString () */



/***************************************************************************************************************************
  KeyedString :: KeyedString ( const char * cszInit , short sNewKey )
****************************************************************************************************************************

  ARGUMENTS   :
    const char  * cszInit
      A pointer to a constant ASCIIZ string that will be copied as the element value of the object being constructed.

    short         sNewKey
      The key value to be associated with the element referenced by 'cszInit'.

    
  DESCRIPTION :
    This constructs a KeyedString object with a value of 'cszInit' and a key of 'sNewKey'.


***************************************************************************************************************************/
KeyedString :: KeyedString ( const char * cszInit , short sNewKey ) : IString ( cszInit ) , sKey ( sNewKey )
{

} /* KeyedString :: KeyedString ( const char * cszInit , short sNewKey ) */



/***************************************************************************************************************************
  KeyedString :: KeyedString ( const IString & rcistring , short sNewKey )
****************************************************************************************************************************

  ARGUMENTS   :
    const IString & rcistring
      A reference to a constant IString that will be copied as the element value of the object being constructed.

    short           sNewKey
      The key value to be associated with the element referenced by 'rcistring'.

    
  DESCRIPTION :
    This constructs a KeyedString object with a value of 'rcistring' and a key of 'sNewKey'.


***************************************************************************************************************************/
KeyedString :: KeyedString ( const IString & rcistring , short sNewKey ) : IString ( rcistring ) , sKey ( sNewKey )
{

} /* KeyedString :: KeyedString ( const IString & rcistring , short sNewKey ) */



/***************************************************************************************************************************
  KeyedString :: KeyedString ( const KeyedString & crkeydstr )
****************************************************************************************************************************

  ARGUMENTS   :
    const KeyedString & crkeydstr
      A reference to a constant KeyedString object that will be the source for this copy constructor


  DESCRIPTION :
    This is the KeyedString copy constructor.  It creates a KeyedString object that is a DEEP copy of the argument 
    'crkeydstr'.


***************************************************************************************************************************/
KeyedString :: KeyedString ( const KeyedString & crkeydstr )
{
  init ( crkeydstr ) ;

} /* KeyedString :: KeyedString ( const KeyedString & crkeydstr ) */



/***************************************************************************************************************************
    const char * KeyedString :: className () const
****************************************************************************************************************************

  RETURNS     :
    A constant pointer to the ASCIIZ string "KeyedString".


  DESCRIPTION :
    This VIRTUAL constant method always returns the class name of the receiver.  This may be used to implement
    a primitive Run Time Type Identification, (RTTI), or anything else you like.  Note that this IS a virtual
    function, and will early bind in the constructors and destructor.  Thus you can also use this method to
    determine in which constructor level you are, although I don't know why you would want to know that!

***************************************************************************************************************************/
const char * KeyedString :: className () const
{
  return  "KeyedString" ;

} /* const char * KeyedString :: className () const */



/***************************************************************************************************************************
  short KeyedString :: init ( const KeyedString & crkeydstr )
****************************************************************************************************************************

  ARGUMENTS   :
    const KeyedString & crkeydstr
      A reference to a constant KeyedString object that will be the source for this copy method


  RETURNS     :
    The receivers' new key valus as a short.


  DESCRIPTION :
    This is the KeyedString copy method.  It initializes a KeyedString object to be a DEEP copy of the argument 
    'crkeydstr'.


***************************************************************************************************************************/
short KeyedString :: init ( const KeyedString & crkeydstr )
{
  //  Set the IString contents to that of crkeydstr
  * (IString *) this = (const IString &) crkeydstr ;

  // And set and return the key value of crkeydstr
  return  setKey ( crkeydstr.key () ) ;

} /* short KeyedString :: init ( const KeyedString & crkeydstr ) */



/***************************************************************************************************************************
  short const & KeyedString :: key () const
****************************************************************************************************************************

  RETURNS     :
    The receivers' key value as a constant reference to a short integer.


  DESCRIPTION :
    This is the accessor for the KeyedStrings' key value.  Since this class is intended to be used to instantiate the IBM
    OCL template KeySortedSet, the signature 'const &'  is matches that required by that class.


***************************************************************************************************************************/
short const & KeyedString :: key () const
{
  return  sKey ;

} /* short const & KeyedString :: key () const */



/***************************************************************************************************************************
  short KeyedString :: setKey ( short sKeyNew )
****************************************************************************************************************************

  ARGUMENTS   :
    short         sKeyNew
      The new key value to be associated with the receiver.

    
  DESCRIPTION :
    This is the accessor method for SETTING the value of the receivers' key.  This method should be used with caution, since
    it affects the order in which the receiver is sorted in the keyed set.


***************************************************************************************************************************/
short KeyedString :: setKey ( short sKeyNew )
{
  return  sKey = sKeyNew ;

} /* short KeyedString :: setKey ( short sKeyNew ) */



/***************************************************************************************************************************
  short const & key ( KeyedString const & crkeystring )
****************************************************************************************************************************

  ARGUMENTS   :
    KeyedString const   & crkeystring
      A constant reference to a KeyedString object whose key value we wish to retrieve.


  RETURNS     :
    The key value of the argument KeyedString Object as a short integer.

    
  DESCRIPTION :
    This is the UTILITY method for getting the key value of a KeyedString object.  This utility method is required by the
    OCL KeySortedSet template.


***************************************************************************************************************************/
short const & key ( KeyedString const & crkeystring )
{
  return  crkeystring.key () ;

} /* short const & key ( KeyedString const & crkeystring ) */





/**************************************     END OF FILE KEYSTRNG.CPP          *********************************************/
