/*** ThirdEye REXX Interface API Usage Example ***/
/* Note. In this version changed the behavior for
   the camxGetPictureName. It now returns whole name
   as it is inside a camera with drive (if any),
   directory names (if any) and picture filename.
*/
/*** (c) 2001 Andrei A. Porodko             ******/

/*** Function Return Code Definitions ************/
RET_OK               =  0
RET_NOT_ENOUGH_MEM   = -1
RET_INSUFF_PARAMS    = -2
RET_NOT_CONNECTED    = -3
RET_NOT_LOADED       = -4
RET_CANT_GET_PICTURE = -5
RET_CANT_DEL_PICTURE = -6
RET_CANT_GET_NUMBER  = -7
RET_CANT_GET_CAMNAME = -8
RET_CANT_TAKE_PIC    = -9


SAY 'ThirdEye REXX Interface v1.5. Usage Example'
SAY '(c) 2001 Andrei A. Porodko'
SAY
SAY 'Registering all Functions for further usage'
SAY

CALL RxFuncAdd 'camxInit', '3eyeRexx', 'camxInit'
CALL camxInit
SAY  camxGetVersion()

port = 'COM1'
baud = 115200
camera = 'KODAK280'
SAY 'Connecting to ' camera' attached to' port '... on' baud

rc = camxConnect(port,baud,camera)
IF  rc \== RET_OK THEN DO
    SAY 'Err: Connection to Camera Failure, code =' rc
    SAY '     Check the Connection or Parameters.'
    CALL camxQuit
    EXIT
END
SAY 'Ok'
SAY
SAY 'Getting Various Information from Camera'
SAY
SAY 'Camera full name = ' camxGetCameraName()
SAY 'Frames taken     = ' camxFramesTaken()
SAY 'Frames left      = ' camxFramesLeft()
SAY
DO i = 1 BY 1 WHILE i < camxFramesTaken()
    name = 'dsc_'i'.jpg'
    SAY 'Downloading picture number' i name
    SAY 'Result of downloading' camxGetPicture(i,name,0)
END

CALL camxDisconnect
CALL camxQuit
EXIT

/*
    End of Example
*/
