/* SVG Viewer EEǂ   */
/*   Rexxg̐D        */
/* Modification log       *//*
2001.2, 3
   T|[gĂȂ̂\, Ƃ肠B(^^)
   , unicode ɂ͑ΉȂ\

 ϐ xmlVar.
   _XXX        ; ϐƂĎgp
   xxx         ; Ή镶߂邽߂̂
   0, 1, 2, 3  ; e[u
   .xxx        ; Attribute

      _SPC     ; Œ: Xy[XƓ̂
      _DISP    ; \tO

      _VAL     ; Sf[^
      _POS     ; ǂݎ|C^[

      _PATH    ; ^O̊KwpX
      _NEST    ; ^ÕlXg
      _TAG     ; ݂̃^O
      _TAGNAME ; ݂̃^O
      _ATTRS   ; ݂̃^OAttributëꗗ

 c:
   &name; ͈ꕔΉĂȂ (`͖)
   vf̓e̕f[^܂ƂłȂ
*/
options 'ETmode'
True = 1; False = 0;

parse arg fname .
if fname == '' then do
   say 't@Cw肵ĉB'
   exit
end
else if stream(fname, 'c', 'query exists') == '' then do
   say 't@C('fname')܂'
   exit
end

/* file check */
str = charin(fname,, 5)
call stream fname, 'c', 'close'
if str == 'EMInk' then do
   call 'InkView' fname
   exit
end

/* load and initialize VREXX */
call RxFuncAdd 'VInit', 'VRexx', 'VINIT'
Rc = VInit()
if Rc = 'ERROR' then signal Cleanup

signal on failure name Cleanup
signal on halt name Cleanup
signal on syntax name Cleanup

/* SVG */
position.left   = 15
position.bottom =  5
position.right  = 65
position.top    = 95
wid = VOpenWindow('SVG Viewer ('fname')', 'WHITE', position)
/* call VSetTitle wid, FileSpec('N', fname) */

call VDrawParms wid,,, 0
call xmlFileRead fname
/*xmlVar._DISP = True*/
/*dbg = 1*/

tag = xmlFindTag('svg')
txt = xmlAttr('viewBox')
if txt == '' then do
   coordX = 0
   coordY = 0
   lenW = svgLUnit(xmlAttr('width'))
   lenH = svgLUnit(xmlAttr('height'))
end
else do
   call tokSetString txt
   coordX = tokGetNum()
   coordY = tokGetNum()
   lenW = tokGetNum()
   lenH = tokGetNum()
end

srchTags = 'path rect polyline polygon line' 'g circle ellipse text'
do forever
   tag = xmlFindTag(srchTags)
   /* if wordpos('defs', xmlVar._NEST) > 0 then do
      say 'defs:' tag '--' xmlVar._NEST
   end */
   select
      when tag == '' then leave
      when tag == 'path' then call svgPath
      when tag == 'line' then do
         x = svgLUnit(xmlAttr('x1')); px.1 = (x -coordX)*1000 %lenW;
         x = svgLUnit(xmlAttr('x2')); px.2 = (x -coordX)*1000 %lenW;
         y = svgLUnit(xmlAttr('y1')); py.1 = 1000 -(y -coordY)*1000 %lenH;
         y = svgLUnit(xmlAttr('y2')); py.2 = 1000 -(y -coordY)*1000 %lenH;
         call VDraw wid, 'LINE', px, py, 2
      end
      when tag == 'rect' then do
         x = svgLUnit(xmlAttr('x')); px.1 = (x -coordX)*1000 %lenW; px.2 = px.1;
         y = svgLUnit(xmlAttr('y')); py.1 = 1000 -(y -coordY)*1000 %lenH; py.4 = py.1;
         x = x +svgLUnit(xmlAttr('width'));  px.3 = (x -coordX)*1000 %lenW; px.4 = px.3;
         y = y +svgLUnit(xmlAttr('height')); py.3 = 1000 -(y -coordY)*1000 %lenH; py.2 = py.3;
         px.5 = px.1; py.5 = py.1;
         call VDraw wid, 'LINE', px, py, 5
      end
      when tag == 'polyline' | tag == 'polygon' then do
         call tokSetString xmlAttr('points')
         do cnt = 1
            x = tokGetNum()
            y = tokGetNum()
            px.cnt = (x -coordX)*1000 %lenW
            py.cnt = 1000 -(y -coordY)*1000 %lenH
            if tokNextCh() == '' then leave
         end
         if tag == 'polygon' then do
            cnt = cnt +1
            px.cnt = px.1
            py.cnt = py.1
         end
         call VDraw wid, 'LINE', px, py, cnt
      end

      when tag == 'g' then do
         str = xmlAttr('transform')
         if str == '' then iterate
         str = strip(translate(str,, xmlVar._SPC))
         if pos('/', srchTags) == 0 then srchTags = srchTags '/'
         k = xmlVar._PATH''
         xmlVar.k = coordX coordY lenW lenH
         do forever
            parse var str fnc'('val')'str
            fnc = strip(fnc)
            if fnc == '' then leave
            else if fnc == 'translate' then do
               call tokSetString val
               coordX = coordX -tokGetNum()
               coordY = coordY -tokGetNum()
            end
            else if fnc == 'scale' then do
               call tokSetString val
               x = tokGetNum()
               y = tokGetNum()
               if y == 0 then y = x
               lenW = lenW /x
               lenH = lenH /y
            end
            else say fnc'('val')'
         end
      end
      when tag == '/g' then do
         k = 'g' xmlVar._NEST''
         if datatype(word(xmlVar.k, 1), 'N') then do
            parse var xmlVar.k coordX coordY lenW lenH
            drop xmlVar.k
         end
      end
      when tag == 'circle' then do
         x = svgLUnit(xmlAttr('cx')); x = (x -coordX)*1000 %lenW;
         y = svgLUnit(xmlAttr('cy')); y = 1000 -(y -coordY)*1000 %lenH;
         r = svgLUnit(xmlAttr('r')); r = r *1000 %lenW;
         call VArc wid, x, y, r, 0, 360
      end
      when tag == 'ellipse' then do
         x = svgLUnit(xmlAttr('cx')); x = (x -coordX)*1000 %lenW;
         y = svgLUnit(xmlAttr('cy')); y = 1000 -(y -coordY)*1000 %lenH;
         r = max(svgLUnit(xmlAttr('rx')), svgLUnit(xmlAttr('ry')))
         r = r *1000 %lenW
         call VArc wid, x, y, r, 0, 360 /* ܂ */
      end
      when tag == 'text' then do
         x = svgLUnit(xmlAttr('x')); x = (x -coordX)*1000 %lenW;
         y = svgLUnit(xmlAttr('y')); y = 1000 -(y -coordY)*1000 %lenH;
         p = pos('<', xmlVar._VAL, xmlVar._POS)
         txt = substr(xmlVar._VAL, xmlVar._POS, p -xmlVar._POS)
         call VSay wid, x, y, strip(translate(txt,, xmlVar._SPC))
      end
      when left(tag, 1) == '/' then nop
   otherwise
      say xmlVar._TAG
      say xmlAttr()
      do forever
         parse pull txt
         if txt == '' then leave
         say xmlAttr(txt)
      end
   end
end

msg.0 = 1
msg.1 = 'I܂'
call VMsgBox 'SVG Viewer', msg, 1 /* 1; OK */
call VClearWindow wid
call VCloseWindow wid
SIGL = 0

Cleanup: call VExit
if SIGL > 0 then say 'stop at' SIGL '('fname')'
exit



svgLUnit: procedure expose lenW
   parse arg str
   if datatype(str, 'N') then return str
   str = strip(translate(str,, '09 0d 0a'x))
   p = verify(str, '+-.'xrange(0, 9))
   if p <= 1 then return 0
   parse var str n =(p) str
   select /* Ȓl (^^) */
      when str == 'em' then return n*28
      when str == 'ex' then return n*14
      when str == 'px' then return n
      when str == 'in' then return n*3.2*10*2.54
      when str == 'cm' then return n*3.2*10
      when str == 'mm' then return n*3.2
      when str == 'pt' then return n*3.2*10*2.54/72
      when str == 'pc' then return n*3.2*10*2.54/72*12
      when str == '%' then return lenW/100*n
   otherwise
      say '??' str
      pull .
   end
   return 0

drawLine:
   if cnt == 1
      then call VDraw wid, 'PIXEL', px, py, 1
      else call VDraw wid, 'LINE', px, py, cnt
   return

svgPath:
call tokSetString xmlAttr('d')
parse value coordX coordY (-1) (-1) with x y sx sy
cnt = 0
nch = tokGetAlp()
do forever
   if dbg == 1 then do
      if tokVar._POS > 0 & tokVar._POS <= length(tokVar._STR) then
         say substr(tokVar._STR, tokVar._POS)
      /* 'BLACK WHITE RED GREEN BLUE CYAN YELLOW PINK' */
      call VForeColor wid, 'PINK'
      pull .
   end
   ch = nch
   uch = translate(ch)
   select
      when ch == '' then leave
      when uch == 'M' then do forever
         if ch == 'M' then do
            x = tokGetNum()
            y = tokGetNum()
         end
         else do
            x = x +tokGetNum()
            y = y +tokGetNum()
         end
         if cnt > 0 then call drawLine
         cnt = 1
         px.cnt = (x -coordX)*1000 %lenW
         py.cnt = 1000 -(y -coordY)*1000 %lenH
         /*if sx < 0 then*/ do; sx = px.1; sy = py.1; end;
         nch = tokNextCh()
         if \datatype(nch, 'N') then leave
      end
      when uch == 'L' then do forever
         if ch == 'L' then do
            x = tokGetNum()
            y = tokGetNum()
         end
         else do
            x = x +tokGetNum()
            y = y +tokGetNum()
         end
         cnt = cnt +1
         px.cnt = (x -coordX)*1000 %lenW
         py.cnt = 1000 -(y -coordY)*1000 %lenH
         nch = tokNextCh()
         if \datatype(nch, 'N') then leave
      end
      when uch == 'Z' then do
         if sx >= 0 then do
            cnt = cnt +1
            px.cnt = sx
            py.cnt = sy
         end
         nch = tokNextCh(+1)
      end
      when uch == 'H' then do forever
         if ch == 'H'
            then x = tokGetNum()
            else x = x +tokGetNum()
         cnt = cnt +1
         px.cnt = (x -coordX)*1000 %lenW
         py.cnt = 1000 -(y -coordY)*1000 %lenH
         nch = tokNextCh()
         if \datatype(nch, 'N') then leave
      end
      when uch == 'V' then do forever
         if ch == 'V'
            then y = tokGetNum()
            else y = y +tokGetNum()
         cnt = cnt +1
         px.cnt = (x -coordX)*1000 %lenW
         py.cnt = 1000 -(y -coordY)*1000 %lenH
         nch = tokNextCh()
         if \datatype(nch, 'N') then leave
      end

      when uch == 'C' | uch == 'S' | uch == 'Q' | uch == 'T' then do
         if cnt > 1 then do
            call drawLine
            px.1 = px.cnt
            py.1 = py.cnt
         end
         do forever
            bx = x; by = y;
            if uch == 'S' | uch == 'T' then do
               px.2 = px.1 +px.1 -px.3
               py.2 = py.1 +py.1 -py.3
               px.3 = px.2; py.3 = py.2; /* 'T' */
            end
            n = word(2 3 3 4, pos(uch, 'CSQT'))
            do cnt = n to 4
               if datatype(ch, 'U') then do
                  x = tokGetNum()
                  y = tokGetNum()
               end
               else do
                  x = bx +tokGetNum()
                  y = by +tokGetNum()
               end
               px.cnt = (x -coordX)*1000 %lenW
               py.cnt = 1000 -(y -coordY)*1000 %lenH
            end
            if uch == 'Q' then do
               px.2 = px.3
               py.2 = py.3
            end
            call VDraw wid, 'SPLINE', px, py, 4
            cnt = 1
            px.cnt = px.4
            py.cnt = py.4
            nch = tokNextCh()
            if \datatype(nch, 'N') then leave
         end
      end
   otherwise
      if cnt > 0 then call drawLine
      cnt = 0
      call charout , ch
      do forever
         n = tokGetNum()
         nch = tokNextCh()
         if \datatype(nch, 'N') then leave
      end
   end
end
if cnt > 0 then call drawLine
return



tokSetString: procedure expose tokVar.
   if \datatype(tokVar._NUM, 'W') then do
      tokVar._NUM = xrange(0, 9)'.'
      tokVar._SPC = '20 09 0d 0a'x','
   end
   tokVar._STR = arg(1)
   tokVar._POS = 1
   return

tokGetAlp: tokNextCh: procedure expose tokVar.
   if datatype(arg(1), 'W') then
      tokVar._POS = tokVar._POS +arg(1)
   if tokVar._POS > 0 then
      tokVar._POS = verify(tokVar._STR, tokVar._SPC,, tokVar._POS)
   if tokVar._POS == 0 then return ''
   ch = substr(tokVar._STR, tokVar._POS, 1)
   if pos(ch, '+-.') == 0 then return ch
   return substr(tokVar._STR, tokVar._POS, 2)

tokGetNum: procedure expose tokVar.
   p = verify(tokVar._STR, tokVar._NUM'+-', 'M', tokVar._POS)
   n = verify(tokVar._STR, tokVar._NUM,, p +1)
   if p == 0 then do; tokVar._POS = tokVar._POS +1; return 0; end;
   if n == 0 then n = length(tokVar._STR) +1
   tokVar._POS = n
   return substr(tokVar._STR, p, n -p)



xmlFileRead: procedure expose xmlVar.
   parse arg fname
   call stream fname, 'c', 'open read'
   xmlVar._VAL = charin(fname,, chars(fname))
   call stream fname, 'c', 'close'
   xmlVar._POS = 1
   xmlVar._NEST = ''
   return

xmlInit: procedure expose xmlVar.
   xmlVar._SPC = '20 09 0d 0a'x
   txt = '[ ]' '" "' "' '"
   do i = 1 to words(txt) by 2
      k = word(txt, i)
      xmlVar.k = word(txt, i +1)
   end

   txt = '<? ?>' '<!-- -->' '<![ ]]>'
   do i = 1 to words(txt) by 2
      k = word(txt, i)
      xmlVar.k = word(txt, i +1)
   end
   xmlVar.0 = words(txt) %2
   do i = 1 to xmlVar.0
      xmlVar.i = word(txt, i *2 -1)
   end
   if \datatype(xmlVar._DISP, 'B') then
      xmlVar._DISP = 0
   return

xmlFindTag: procedure expose xmlVar.   coordX coordY lenW lenH
parse arg srch
if \datatype(xmlVar.0, 'W') then call xmlInit
p = xmlVar._POS
if \datatype(p, 'W') then p = 1
do loop = 1
   plt = pos('<', xmlVar._VAL, p)
   if plt == 0 then leave

   txt = substr(xmlVar._VAL, plt, 5 /* Ȃ̓KȒ؂ */)
   do i = 1 to xmlVar.0
      k = xmlVar.i
      if \abbrev(txt, k) then iterate

      p = pos(xmlVar.k, xmlVar._VAL, plt +length(k))
      if p == 0 then trace ???R /* 񂪌Ȃ */
      p = p +length(xmlVar.k)
      if xmlVar._DISP then
         say '1b'x'[1;33m'substr(xmlVar._VAL, plt, p -plt)'1b'x'[m'
      iterate loop
   end

   p = plt +1
   if abbrev(txt, '<!') then do forever
      p = verify(xmlVar._VAL, "'"'"[>', 'M', p +1)
      if p == 0 then trace ???R
      ch = substr(xmlVar._VAL, p, 1)
      if ch == '>' then iterate loop
      p = pos(xmlVar.ch, xmlVar._VAL, p +1)
      if p == 0 then trace ???R /* 񂪌Ȃ */
   end

   if abbrev(txt, '</') then do
      /* ^O */
      p = plt +2
      n = verify(xmlVar._VAL, xmlVar._SPC'>', 'M', p)
      if n == 0 then trace ???R
      tag = substr(xmlVar._VAL, p, n -p)
      p = pos('>', xmlVar._VAL, n)
      if word(xmlVar._NEST, 1) == tag then
         xmlVar._NEST = subword(xmlVar._NEST, 2)
      else say '# </'tag'>' xmlVar._NEST'?'

      if pos('/', srch) == 0 then iterate
      if srch \= '' then if wordpos(tag, srch) == 0 then
         iterate

      xmlVar._POS = p +1
      return '/'tag
   end
   else do
      /* Jn^O */
      p = plt +1
      n = verify(xmlVar._VAL, xmlVar._SPC'>', 'M', p)
      if n == 0 then trace ???R
      tag = substr(xmlVar._VAL, p, n -p)
      do forever
         p = verify(xmlVar._VAL, "'"'">', 'M', p +1)
         if p == 0 then trace ???R
         ch = substr(xmlVar._VAL, p, 1)
         if ch == '>' then do
            xmlVar._PATH = tag xmlVar._NEST
            if substr(xmlVar._VAL, p -1, 1) \= '/' then
               xmlVar._NEST = xmlVar._PATH
            if srch \= '' then if wordpos(tag, srch) == 0 then
               leave

            xmlVar._TAG = substr(xmlVar._VAL, plt +1, p -plt -1)
            xmlVar._POS = p +1
            return tag
         end
         p = pos(xmlVar.ch, xmlVar._VAL, p +1)
         if p == 0 then trace ???R /* 񂪌Ȃ */
      end
   end
end
if xmlVar._NEST == '' then nop
else say '#' xmlVar._NEST
return ''

xmlAttr: procedure expose xmlVar.
   if xmlVar._TAG \== '' then do
      xmlVar._ATTRS = ''
      p = verify(xmlVar._TAG, xmlVar._SPC, 'M')
      do while p > 0
         n = pos('=', xmlVar._TAG, p)
         if n == 0 then leave
         k = strip(translate(substr(xmlVar._TAG, p, n -p),, xmlVar._SPC))
         p = verify(xmlVar._TAG, xmlVar._SPC,, n +1)
         if p == 0 then trace ???R /* lȂ */
         ch = substr(xmlVar._TAG, p, 1)
         n = pos(xmlVar.ch, xmlVar._TAG, p +1)
         if n == 0 then trace ???R /* 񂪌Ȃ */
         xmlVar._ATTRS = xmlVar._ATTRS k
         k = '.'k
         xmlVar.k = ChgDefs(substr(xmlVar._TAG, p +1, n -p -1))
         p = verify(xmlVar._TAG, xmlVar._SPC,, n +1)
      end
      xmlVar._TAG = ''
   end
   parse arg atr
   if atr == '' then return xmlVar._ATTRS
   if wordpos(atr, xmlVar._ATTRS) == 0 then return ''
   atr = '.'atr
   return xmlVar.atr

ChgDefs: procedure
   parse arg str
   res = ''
   p = 1
   do forever
      pdf = pos('&', str, p)
      if pdf == 0 then leave
      ptm = pos(';', str, pdf)
      if ptm == 0 then leave
      txt = substr(str, pdf, ptm -pdf)
      select
         when txt == '&lt' then ch = '<'
         when txt == '&gt' then ch = '>'
         when txt == '&amp' then ch = '&'
         when txt == '&apos' then ch = "'"
         when txt == '&quot' then ch = '"'
         when abbrev(txt, '&#x') then do
            txt = substr(txt, 4)
            if datatype(txt, 'x') then ch = x2c(txt); else ch = 'hex?'txt;
         end
         when abbrev(txt, '&#') then do
            txt = substr(txt, 3)
            if datatype(txt, 'w') then ch = d2c(txt); else ch = 'dec?'txt;
         end
      otherwise
         ch = '???'
      end
      res = res ||substr(str, p, pdf -p) ||ch
      p = ptm +1
   end
   return res ||substr(str, p)

/**  End of Script  **/
